/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared.blocks;

import cuchaz.modsShared.blocks.Coords;
import cuchaz.modsShared.math.BoxCorner;
import cuchaz.modsShared.math.CircleRange;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;

public enum BlockSide {
    Bottom(0, -1, 0, new BoxCorner[]{BoxCorner.BottomNorthEast, BoxCorner.BottomNorthWest, BoxCorner.BottomSouthWest, BoxCorner.BottomSouthEast}){

        @Override
        public void renderSide(RenderBlocks renderBlocks, Block block, double x, double y, double z, IIcon icon) {
            renderBlocks.func_147768_a(block, x, y, z, icon);
        }

        @Override
        public int getWidth(int dx, int dy, int dz) {
            return dx;
        }

        @Override
        public int getHeight(int dx, int dy, int dz) {
            return dz;
        }

        @Override
        public int getU(int x, int y, int z) {
            return x;
        }

        @Override
        public int getV(int x, int y, int z) {
            return z;
        }

        @Override
        public boolean isMoreExtremal(Coords compareWith, Coords compareTo) {
            return compareWith.y < compareTo.y;
        }

        @Override
        public double getFractionSubmerged(int y, double waterHeight) {
            return (double)y <= waterHeight ? 1.0 : 0.0;
        }
    }
    ,
    Top(0, 1, 0, new BoxCorner[]{BoxCorner.TopNorthEast, BoxCorner.TopNorthWest, BoxCorner.TopSouthWest, BoxCorner.TopSouthEast}){

        @Override
        public void renderSide(RenderBlocks renderBlocks, Block block, double x, double y, double z, IIcon icon) {
            renderBlocks.func_147806_b(block, x, y, z, icon);
        }

        @Override
        public int getWidth(int dx, int dy, int dz) {
            return dx;
        }

        @Override
        public int getHeight(int dx, int dy, int dz) {
            return dz;
        }

        @Override
        public int getU(int x, int y, int z) {
            return x;
        }

        @Override
        public int getV(int x, int y, int z) {
            return z;
        }

        @Override
        public boolean isMoreExtremal(Coords compareWith, Coords compareTo) {
            return compareWith.y > compareTo.y;
        }

        @Override
        public double getFractionSubmerged(int y, double waterHeight) {
            return (double)(y + 1) <= waterHeight ? 1.0 : 0.0;
        }
    }
    ,
    North(0, 0, -1, new BoxCorner[]{BoxCorner.TopNorthWest, BoxCorner.TopNorthEast, BoxCorner.BottomNorthEast, BoxCorner.BottomNorthWest}){

        @Override
        public void renderSide(RenderBlocks renderBlocks, Block block, double x, double y, double z, IIcon icon) {
            renderBlocks.func_147761_c(block, x, y, z, icon);
        }

        @Override
        public int getWidth(int dx, int dy, int dz) {
            return dx;
        }

        @Override
        public int getHeight(int dx, int dy, int dz) {
            return dy;
        }

        @Override
        public int getU(int x, int y, int z) {
            return x;
        }

        @Override
        public int getV(int x, int y, int z) {
            return y;
        }

        @Override
        public boolean isMoreExtremal(Coords compareWith, Coords compareTo) {
            return compareWith.z < compareTo.z;
        }

        @Override
        public double getFractionSubmerged(int y, double waterHeight) {
            return BlockSide.getSideFractionSubmerged(y, waterHeight);
        }
    }
    ,
    South(0, 0, 1, new BoxCorner[]{BoxCorner.TopSouthEast, BoxCorner.TopSouthWest, BoxCorner.BottomSouthWest, BoxCorner.BottomSouthEast}){

        @Override
        public void renderSide(RenderBlocks renderBlocks, Block block, double x, double y, double z, IIcon icon) {
            renderBlocks.func_147734_d(block, x, y, z, icon);
        }

        @Override
        public int getWidth(int dx, int dy, int dz) {
            return dx;
        }

        @Override
        public int getHeight(int dx, int dy, int dz) {
            return dy;
        }

        @Override
        public int getU(int x, int y, int z) {
            return x;
        }

        @Override
        public int getV(int x, int y, int z) {
            return y;
        }

        @Override
        public boolean isMoreExtremal(Coords compareWith, Coords compareTo) {
            return compareWith.z > compareTo.z;
        }

        @Override
        public double getFractionSubmerged(int y, double waterHeight) {
            return BlockSide.getSideFractionSubmerged(y, waterHeight);
        }
    }
    ,
    West(-1, 0, 0, new BoxCorner[]{BoxCorner.TopSouthWest, BoxCorner.TopNorthWest, BoxCorner.BottomNorthWest, BoxCorner.BottomSouthWest}){

        @Override
        public void renderSide(RenderBlocks renderBlocks, Block block, double x, double y, double z, IIcon icon) {
            renderBlocks.func_147798_e(block, x, y, z, icon);
        }

        @Override
        public int getWidth(int dx, int dy, int dz) {
            return dz;
        }

        @Override
        public int getHeight(int dx, int dy, int dz) {
            return dy;
        }

        @Override
        public int getU(int x, int y, int z) {
            return z;
        }

        @Override
        public int getV(int x, int y, int z) {
            return y;
        }

        @Override
        public boolean isMoreExtremal(Coords compareWith, Coords compareTo) {
            return compareWith.x < compareTo.x;
        }

        @Override
        public double getFractionSubmerged(int y, double waterHeight) {
            return BlockSide.getSideFractionSubmerged(y, waterHeight);
        }
    }
    ,
    East(1, 0, 0, new BoxCorner[]{BoxCorner.TopNorthEast, BoxCorner.TopSouthEast, BoxCorner.BottomSouthEast, BoxCorner.BottomNorthEast}){

        @Override
        public void renderSide(RenderBlocks renderBlocks, Block block, double x, double y, double z, IIcon icon) {
            renderBlocks.func_147764_f(block, x, y, z, icon);
        }

        @Override
        public int getWidth(int dx, int dy, int dz) {
            return dz;
        }

        @Override
        public int getHeight(int dx, int dy, int dz) {
            return dy;
        }

        @Override
        public int getU(int x, int y, int z) {
            return z;
        }

        @Override
        public int getV(int x, int y, int z) {
            return y;
        }

        @Override
        public boolean isMoreExtremal(Coords compareWith, Coords compareTo) {
            return compareWith.x > compareTo.x;
        }

        @Override
        public double getFractionSubmerged(int y, double waterHeight) {
            return BlockSide.getSideFractionSubmerged(y, waterHeight);
        }
    };

    private static BlockSide[] m_xzSides;
    private BlockSide m_oppositeSide;
    private int m_xzOffset;
    private int m_dx;
    private int m_dy;
    private int m_dz;
    private BoxCorner[] m_corners;

    private BlockSide(int dx, int dy, int dz, BoxCorner[] corners) {
        this.m_dx = dx;
        this.m_dy = dy;
        this.m_dz = dz;
        this.m_corners = corners;
        this.m_oppositeSide = null;
    }

    public int getId() {
        return this.ordinal();
    }

    public int getDx() {
        return this.m_dx;
    }

    public int getDy() {
        return this.m_dy;
    }

    public int getDz() {
        return this.m_dz;
    }

    public BoxCorner[] getCorners() {
        return this.m_corners;
    }

    public BlockSide getOppositeSide() {
        return this.m_oppositeSide;
    }

    public int getXZOffset() {
        return this.m_xzOffset;
    }

    public BlockSide rotateXZCcw(int offset) {
        return m_xzSides[(this.m_xzOffset + m_xzSides.length - offset) % m_xzSides.length];
    }

    public BlockSide rotateXZCw(int offset) {
        return m_xzSides[(this.m_xzOffset + offset) % m_xzSides.length];
    }

    public static BlockSide getById(int side) {
        return BlockSide.values()[side];
    }

    public static BlockSide getByYaw(float yaw) {
        int offset = MathHelper.func_76141_d((float)(CircleRange.mapZeroTo360(yaw) * 4.0f / 360.0f + 0.5f)) % m_xzSides.length;
        return m_xzSides[offset].getOppositeSide();
    }

    public static BlockSide getByXZOffset(int offset) {
        return m_xzSides[offset];
    }

    public abstract void renderSide(RenderBlocks var1, Block var2, double var3, double var5, double var7, IIcon var9);

    public abstract int getWidth(int var1, int var2, int var3);

    public abstract int getHeight(int var1, int var2, int var3);

    public abstract int getU(int var1, int var2, int var3);

    public abstract int getV(int var1, int var2, int var3);

    public abstract boolean isMoreExtremal(Coords var1, Coords var2);

    public abstract double getFractionSubmerged(int var1, double var2);

    public static BlockSide[] xzSides() {
        return m_xzSides;
    }

    private static double getSideFractionSubmerged(int y, double waterHeight) {
        double bottom = y;
        double top = y + 1;
        if (top <= waterHeight) {
            return 1.0;
        }
        if (bottom > waterHeight) {
            return 0.0;
        }
        return waterHeight - bottom;
    }

    static {
        BlockSide.Bottom.m_oppositeSide = Top;
        BlockSide.Top.m_oppositeSide = Bottom;
        BlockSide.East.m_oppositeSide = West;
        BlockSide.West.m_oppositeSide = East;
        BlockSide.North.m_oppositeSide = South;
        BlockSide.South.m_oppositeSide = North;
        m_xzSides = new BlockSide[]{North, East, South, West};
        BlockSide.North.m_xzOffset = 0;
        BlockSide.East.m_xzOffset = 1;
        BlockSide.South.m_xzOffset = 2;
        BlockSide.West.m_xzOffset = 3;
    }
}

