/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared.blocks;

import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.Coords;

public class BlockArray {
    private int m_uMin;
    private int m_vMin;
    private Coords[][] m_blocks;

    public BlockArray(int uMin, int vMin, int width, int height) {
        this.m_uMin = uMin;
        this.m_vMin = vMin;
        this.m_blocks = new Coords[height][width];
    }

    public int getWidth() {
        return this.m_blocks[0].length;
    }

    public int getHeight() {
        return this.m_blocks.length;
    }

    public int getUMin() {
        return this.m_uMin;
    }

    public int getUMax() {
        return this.m_uMin + this.getWidth() - 1;
    }

    public int getVMin() {
        return this.m_vMin;
    }

    public int getVMax() {
        return this.m_vMin + this.getHeight() - 1;
    }

    public Coords getBlock(int u, int v) {
        return this.m_blocks[this.toZeroBasedV(v)][this.toZeroBasedU(u)];
    }

    public void setBlock(int u, int v, Coords coords) {
        this.m_blocks[this.toZeroBasedV((int)v)][this.toZeroBasedU((int)u)] = coords;
    }

    public int toZeroBasedU(int u) {
        return u - this.m_uMin;
    }

    public int toZeroBasedV(int v) {
        return v - this.m_vMin;
    }

    public BlockArray newEmptyCopy() {
        return new BlockArray(this.m_uMin, this.m_vMin, this.getWidth(), this.getHeight());
    }

    public BlockSet toBlockSet() {
        BlockSet blocks = new BlockSet();
        for (int u = 0; u < this.getWidth(); ++u) {
            for (int v = 0; v < this.getHeight(); ++v) {
                if (this.m_blocks[v][u] == null) continue;
                blocks.add(this.m_blocks[v][u]);
            }
        }
        return blocks;
    }

    public static enum Rotation {
        None{

            @Override
            public BlockArray rotate(BlockArray blocks) {
                return blocks;
            }
        }
        ,
        Ccw90{

            @Override
            public BlockArray rotate(BlockArray blocks) {
                BlockArray out = new BlockArray(0, 0, blocks.getHeight(), blocks.getWidth());
                for (int u = 0; u < out.getWidth(); ++u) {
                    for (int v = 0; v < out.getHeight(); ++v) {
                        ((BlockArray)out).m_blocks[v][u] = blocks.m_blocks[blocks.getHeight() - 1 - u][v];
                    }
                }
                return out;
            }
        };


        public abstract BlockArray rotate(BlockArray var1);
    }
}

