/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared;

import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.Entity;

public class Environment {
    private static Boolean m_isObfuscated = null;

    public static boolean isObfuscated() {
        if (m_isObfuscated == null) {
            try {
                Entity.class.getDeclaredMethod("onUpdate", new Class[0]);
                m_isObfuscated = false;
            }
            catch (NoSuchMethodException ex) {
                m_isObfuscated = true;
            }
            catch (SecurityException ex) {
                throw new Error("Unable to reflect on Minecraft classes!", ex);
            }
        }
        return m_isObfuscated;
    }

    public static String getRuntimeName(String name, String id) {
        return Environment.isObfuscated() ? id : name;
    }

    public static Side getSide() {
        String threadName = Thread.currentThread().getName();
        if (threadName.equalsIgnoreCase("client thread")) {
            return Side.CLIENT;
        }
        if (threadName.equalsIgnoreCase("server thread")) {
            return Side.SERVER;
        }
        throw new Error("I don't know what side we're on for thread " + threadName);
    }

    public static boolean isClient() {
        return Environment.getSide() == Side.CLIENT;
    }

    public static boolean isServer() {
        return Environment.getSide() == Side.SERVER;
    }
}

