/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared;

import java.awt.Color;

public class ColorUtils {
    private static final int DefaultAlpha = 255;

    public static int getColor(Color c) {
        return ColorUtils.getColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    public static int getGrey(int grey) {
        return ColorUtils.getColor(grey, grey, grey, 255);
    }

    public static int getGrey(int grey, int a) {
        return ColorUtils.getColor(grey, grey, grey, a);
    }

    public static int getColor(int r, int g, int b) {
        return ColorUtils.getColor(r, g, b, 255);
    }

    public static int getColor(int r, int g, int b, int a) {
        return b & 0xFF | (g & 0xFF) << 8 | (r & 0xFF) << 16 | (a & 0xFF) << 24;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static float getRedf(int color) {
        return (float)ColorUtils.getRed(color) / 255.0f;
    }

    public static float getGreenf(int color) {
        return (float)ColorUtils.getGreen(color) / 255.0f;
    }

    public static float getBluef(int color) {
        return (float)ColorUtils.getBlue(color) / 255.0f;
    }

    public static float getAlphaf(int color) {
        return (float)ColorUtils.getAlpha(color) / 255.0f;
    }
}

