/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.cuchazinteractive;

import com.google.common.collect.Maps;
import cuchaz.cuchazinteractive.CuchazInteractive;
import cuchaz.cuchazinteractive.Signer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Supporters {
    public static final int InvalidSupporterId = -1;
    private static TreeMap<Integer, List<String>> m_supporters;

    public static List<String> getSortedNames() {
        return Supporters.getSortedNames(1);
    }

    public static List<String> getSortedNames(int minRank) {
        ArrayList<String> names = new ArrayList<String>();
        for (int rank : m_supporters.descendingKeySet()) {
            names.addAll((Collection<String>)m_supporters.get(rank));
            if (rank > minRank) continue;
            break;
        }
        return names;
    }

    public static int getId(String name) {
        name = Supporters.normalizeName(name);
        for (int rank : m_supporters.descendingKeySet()) {
            List<String> names = m_supporters.get(rank);
            for (int i = 0; i < names.size(); ++i) {
                if (!Supporters.normalizeName(names.get(i)).equals(name)) continue;
                return rank | i << 8;
            }
        }
        return -1;
    }

    public static String getName(int id) {
        int rank = Supporters.getRank(id);
        int index = Supporters.getIndex(id);
        List<String> names = m_supporters.get(rank);
        if (names != null && index < names.size()) {
            return names.get(index);
        }
        return null;
    }

    public static int getRank(int id) {
        return id & 0xFF;
    }

    private static int getIndex(int id) {
        return id >> 8 & 0xFFFFFF;
    }

    private static String normalizeName(String name) {
        return name.toLowerCase().replace(" ", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readResource(String resourceName) throws IOException {
        InputStream in = null;
        try {
            int len;
            String path = "/assets/cuchazinteractive/" + resourceName;
            in = Supporters.class.getResourceAsStream(path);
            if (in == null) {
                CuchazInteractive.log.warn(String.format("Unable to read resource: %s", path));
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) >= 0) {
                buf.write(buffer, 0, len);
            }
            byte[] byArray = buf.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    static {
        try {
            m_supporters = Maps.newTreeMap();
            byte[] supporters = Supporters.readResource("supporters.txt");
            String thing = "MIIBuDCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYUAAoGBAN5wyqbzUkd8daZ6R3ndWgdqvkANa8fSYxNTvY0XAJwvT4spo6ZXg/TZVAt8Z1r/E04AOtQfUXr3aJ5spcYCdn6wkDuDWyuivq668vxKQG+erlDNv9nfU5NWOIXLoWycu+BLaFexcgytPncXFZrslYIp2uy7kflRUQaMle7EoLcX";
            byte[] sig = Supporters.readResource("supporters.sig");
            if (Signer.verify(supporters, sig, thing)) {
                String line;
                Pattern pattern = Pattern.compile("^Rank (\\d+):$");
                int currentRank = 0;
                BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(supporters)));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    Matcher matcher = pattern.matcher(line);
                    if (matcher.matches()) {
                        currentRank = Integer.parseInt(matcher.group(1));
                        m_supporters.put(currentRank, new ArrayList());
                        continue;
                    }
                    m_supporters.get(currentRank).add(line);
                }
                in.close();
            } else {
                m_supporters.put(0, Arrays.asList("Supporters file has been corrupted!"));
            }
        }
        catch (IOException ex) {
            CuchazInteractive.log.warn("Unable to load supporters!", (Throwable)ex);
        }
    }
}

