/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.blockitem;

import ckathode.archimedes.ArchimedesShipMod;
import ckathode.archimedes.chunk.AssembleResult;
import ckathode.archimedes.chunk.ChunkAssembler;
import ckathode.archimedes.entity.EntityShip;
import ckathode.archimedes.entity.IShipTileEntity;
import ckathode.archimedes.entity.ShipInfo;
import ckathode.archimedes.network.MsgAssembleResult;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class TileEntityHelm
extends TileEntity
implements IShipTileEntity {
    private EntityShip activeShip = null;
    private ShipInfo info = new ShipInfo();
    private AssembleResult assembleResult = null;
    private AssembleResult prevResult = null;

    public boolean canUpdate() {
        return false;
    }

    public ShipInfo getShipInfo() {
        return this.info;
    }

    public AssembleResult getAssembleResult() {
        return this.assembleResult;
    }

    public AssembleResult getPrevAssembleResult() {
        return this.prevResult;
    }

    public void setShipInfo(ShipInfo shipinfo) {
        if (shipinfo == null) {
            throw new NullPointerException("Cannot set null ship info");
        }
        this.info = shipinfo;
    }

    public void setAssembleResult(AssembleResult result) {
        this.assembleResult = result;
    }

    public void setPrevAssembleResult(AssembleResult result) {
        this.prevResult = result;
    }

    @Override
    public void setParentShip(EntityShip entityship, int x, int y, int z) {
        this.activeShip = entityship;
    }

    @Override
    public EntityShip getParentShip() {
        return this.activeShip;
    }

    public boolean assembleShip(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            this.prevResult = this.assembleResult;
            ChunkAssembler assembler = new ChunkAssembler(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.assembleResult = assembler.doAssemble();
            this.sendAssembleResult(player, false);
            this.sendAssembleResult(player, true);
            switch (this.assembleResult.getCode()) {
                case 1: 
                case 7: {
                    return true;
                }
                case 2: {
                    ChatComponentText c = new ChatComponentText("Cannot create ship with more than " + ArchimedesShipMod.instance.modConfig.maxShipChunkBlocks + " blocks");
                    player.func_145747_a((IChatComponent)c);
                    break;
                }
                case 3: {
                    ChatComponentText c = new ChatComponentText("Cannot create ship with no ship marker");
                    player.func_145747_a((IChatComponent)c);
                    break;
                }
                case 4: {
                    ChatComponentText c = new ChatComponentText("An error occured while assembling ship. See console log for details.");
                    player.func_145747_a((IChatComponent)c);
                    break;
                }
                case 0: {
                    ChatComponentText c = new ChatComponentText("Nothing was assembled");
                    player.func_145747_a((IChatComponent)c);
                    break;
                }
            }
        }
        return false;
    }

    public boolean mountShip(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && this.assembleResult != null && this.assembleResult.isOK()) {
            EntityShip entity;
            this.assembleResult.checkConsistent(this.field_145850_b);
            this.sendAssembleResult(player, false);
            if (this.assembleResult.getCode() == 6) {
                return false;
            }
            if (this.assembleResult.getCode() == 7) {
                ChatComponentText c = new ChatComponentText("Ship contains changes");
                player.func_145747_a((IChatComponent)c);
            }
            if ((entity = this.assembleResult.getEntity(this.field_145850_b)) != null) {
                entity.setInfo(this.info);
                if (this.field_145850_b.func_72838_d((Entity)entity)) {
                    player.func_70078_a((Entity)entity);
                    this.assembleResult = null;
                    return true;
                }
            }
        }
        return false;
    }

    public void undoCompilation(EntityPlayer player) {
        this.assembleResult = this.prevResult;
        this.prevResult = null;
        this.sendAssembleResult(player, false);
        this.sendAssembleResult(player, true);
    }

    public void sendAssembleResult(EntityPlayer player, boolean prev) {
        if (!this.field_145850_b.field_72995_K) {
            AssembleResult res = prev ? this.prevResult : this.assembleResult;
            MsgAssembleResult msg = new MsgAssembleResult(res, prev);
            ArchimedesShipMod.instance.pipeline.sendTo(msg, (EntityPlayerMP)player);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeNBTforSending(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        int id;
        Entity entity;
        super.func_145839_a(compound);
        this.field_145847_g = compound.func_74762_e("meta");
        this.info.shipName = compound.func_74779_i("name");
        if (compound.func_74764_b("ship") && this.field_145850_b != null && (entity = this.field_145850_b.func_73045_a(id = compound.func_74762_e("ship"))) instanceof EntityShip) {
            this.activeShip = (EntityShip)entity;
        }
        if (compound.func_74764_b("res")) {
            this.assembleResult = new AssembleResult(compound.func_74775_l("res"), this.field_145850_b);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("meta", this.field_145847_g);
        compound.func_74778_a("name", this.info.shipName);
        if (this.activeShip != null && !this.activeShip.field_70128_L) {
            compound.func_74768_a("ship", this.activeShip.func_145782_y());
        }
        if (this.assembleResult != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.assembleResult.writeNBTFully(comp);
            compound.func_74782_a("res", (NBTBase)comp);
        }
    }

    public void writeNBTforSending(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("meta", this.field_145847_g);
        compound.func_74778_a("name", this.info.shipName);
        if (this.activeShip != null && !this.activeShip.field_70128_L) {
            compound.func_74768_a("ship", this.activeShip.func_145782_y());
        }
        if (this.assembleResult != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.assembleResult.writeNBTMetadata(comp);
            compound.func_74782_a("res", (NBTBase)comp);
        }
    }
}

