/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import cofh.api.energy.IEnergyContainerItem;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ModBoolean;
import tconstruct.util.config.PHConstruct;

public class ModFlux
extends ModBoolean {
    public ArrayList<ItemStack> batteries = new ArrayList();
    public int modifiersRequired = 1;

    public ModFlux() {
        super(new ItemStack[0], 9, "Flux", "\u00a7e", "");
    }

    @Override
    public boolean matches(ItemStack[] input, ItemStack tool) {
        String[] traits;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        for (String trait : traits = ((IModifyable)tool.func_77973_b()).getTraits()) {
            if (!"ammo".equals(trait)) continue;
            return false;
        }
        ItemStack foundBattery = null;
        for (ItemStack stack : input) {
            for (ItemStack battery : this.batteries) {
                if (stack == null || stack.func_77973_b() != battery.func_77973_b() || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                if (foundBattery != null) {
                    return false;
                }
                foundBattery = stack;
            }
        }
        if (foundBattery == null) {
            return false;
        }
        int maxEnergy = ((IEnergyContainerItem)foundBattery.func_77973_b()).getMaxEnergyStored(foundBattery);
        if (PHConstruct.balancedFluxModifier && tags.func_74762_e("TotalDurability") < maxEnergy / 1000) {
            return false;
        }
        if (tags.func_74767_n(this.key)) {
            int a = ((IEnergyContainerItem)foundBattery.func_77973_b()).getMaxEnergyStored(foundBattery);
            int b = ((ToolCore)tool.func_77973_b()).getMaxEnergyStored(tool);
            return ((IEnergyContainerItem)foundBattery.func_77973_b()).getMaxEnergyStored(foundBattery) > ((ToolCore)tool.func_77973_b()).getMaxEnergyStored(tool);
        }
        return tags.func_74762_e("Modifiers") >= this.modifiersRequired;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        int progress;
        NBTTagCompound tags = tool.func_77978_p();
        if (!tags.func_74764_b(this.key)) {
            int modifiers = tags.func_74775_l("InfiTool").func_74762_e("Modifiers");
            tags.func_74775_l("InfiTool").func_74768_a("Modifiers", modifiers -= this.modifiersRequired);
            this.addModifierTip(tool, "\u00a7eFlux");
        }
        tags.func_74775_l("InfiTool").func_74757_a(this.key, true);
        ItemStack inputBattery = null;
        for (ItemStack stack : input) {
            for (ItemStack battery : this.batteries) {
                if (stack == null || stack.func_77973_b() != battery.func_77973_b() || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                inputBattery = stack;
            }
        }
        IEnergyContainerItem energyContainer = (IEnergyContainerItem)inputBattery.func_77973_b();
        int charge = energyContainer.getEnergyStored(inputBattery);
        if (tags.func_74764_b("Energy")) {
            charge += tags.func_74762_e("Energy");
        }
        int maxCharge = energyContainer.getMaxEnergyStored(inputBattery);
        ItemStack subject42 = inputBattery.func_77946_l();
        int change = 1;
        for (progress = 0; progress < maxCharge && change > 0; progress += change) {
            change = energyContainer.receiveEnergy(subject42, 100000, false);
        }
        int maxExtract = energyContainer.extractEnergy(subject42, Integer.MAX_VALUE, true);
        subject42 = inputBattery.func_77946_l();
        change = 1;
        for (progress = 0; progress < maxCharge && change > 0; progress += change) {
            change = energyContainer.extractEnergy(subject42, 100000, false);
        }
        int maxReceive = energyContainer.receiveEnergy(subject42, Integer.MAX_VALUE, true);
        charge = Math.min(charge, maxCharge);
        tags.func_74768_a("Energy", charge);
        tags.func_74768_a("EnergyMax", maxCharge);
        tags.func_74768_a("EnergyExtractionRate", maxExtract);
        tags.func_74768_a("EnergyReceiveRate", maxReceive);
        tags.func_74768_a(this.key, 1);
        ToolCore toolcore = (ToolCore)tool.func_77973_b();
    }
}

