/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.item;

import ic2.api.item.IElectricItemManager;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class ElectricItemManagerIC2_1710
implements IElectricItemManager {
    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            ItemElectricBase item = (ItemElectricBase)itemStack.func_77973_b();
            if (amount > item.getMaxCharge(itemStack)) {
                amount = item.getMaxCharge(itemStack);
            }
            float energy = (float)amount * EnergyConfigHandler.IC2_RATIO;
            float rejectedElectricity = Math.max(item.getElectricityStored(itemStack) + energy - item.getMaxElectricityStored(itemStack), 0.0f);
            float energyToReceive = energy - rejectedElectricity;
            if (!ignoreTransferLimit && energyToReceive > item.transferMax) {
                energyToReceive = item.transferMax;
            }
            if (!simulate) {
                item.setElectricity(itemStack, item.getElectricityStored(itemStack) + energyToReceive);
            }
            return energyToReceive / EnergyConfigHandler.IC2_RATIO;
        }
        return 0.0;
    }

    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            ItemElectricBase item = (ItemElectricBase)itemStack.func_77973_b();
            float energy = (float)amount / EnergyConfigHandler.TO_IC2_RATIO;
            float energyToTransfer = Math.min(item.getElectricityStored(itemStack), energy);
            if (!ignoreTransferLimit) {
                energyToTransfer = Math.min(energyToTransfer, item.transferMax);
            }
            if (!simulate) {
                item.setElectricity(itemStack, item.getElectricityStored(itemStack) - energyToTransfer);
            }
            return energyToTransfer * EnergyConfigHandler.TO_IC2_RATIO;
        }
        return 0.0;
    }

    public double getCharge(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            ItemElectricBase item = (ItemElectricBase)itemStack.func_77973_b();
            return item.getElectricityStored(itemStack) * EnergyConfigHandler.TO_IC2_RATIO;
        }
        return 0.0;
    }

    public boolean canUse(ItemStack itemStack, double amount) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            return this.getCharge(itemStack) >= amount;
        }
        return false;
    }

    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            return this.discharge(itemStack, amount, 1, true, false, false) >= amount - 1.0;
        }
        return false;
    }

    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
    }

    public String getToolTip(ItemStack itemStack) {
        return null;
    }
}

