/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.util.decorators;

import com.gildedgames.util.ui.common.Gui;
import com.gildedgames.util.ui.common.GuiDecorator;
import com.gildedgames.util.ui.common.Ui;
import com.gildedgames.util.ui.data.UIContainer;
import com.gildedgames.util.ui.data.rect.ModDim2D;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.graphics.Graphics2D;
import com.gildedgames.util.ui.input.InputProvider;
import com.gildedgames.util.ui.util.rect.RectSeekable;
import com.gildedgames.util.ui.util.rect.RectSeeker;
import com.google.common.collect.ImmutableList;
import org.lwjgl.opengl.GL11;

public class ScissorableGui
extends GuiDecorator<Gui>
implements RectSeekable {
    protected ModDim2D scissoredArea;
    private ImmutableList<RectSeeker> seekers = ImmutableList.of((Object)new Seeker(this));

    public ScissorableGui(Rect scissoredArea, Gui gui) {
        super(gui);
        this.scissoredArea = new ModDim2D().set(scissoredArea);
    }

    public ModDim2D getScissoredArea() {
        return this.scissoredArea;
    }

    @Override
    protected void preInitContent(InputProvider input) {
    }

    @Override
    protected void postInitContent(InputProvider input) {
    }

    @Override
    public void draw(Graphics2D graphics, InputProvider input) {
        for (UIContainer container : ((Gui)this.getDecoratedElement()).seekAllContent()) {
            for (Ui ui : container) {
                if (!(ui instanceof Gui)) continue;
                Gui gui = (Gui)ui;
                if (!gui.dim().intersects(this.getScissoredArea())) {
                    gui.setEnabled(false);
                    gui.setVisible(false);
                    continue;
                }
                gui.setEnabled(true);
                gui.setVisible(true);
            }
        }
        GL11.glPushMatrix();
        double lowerLeftCornerY = this.getScissoredArea().y() + this.getScissoredArea().height();
        double cornerX = this.getScissoredArea().x() * input.getScaleFactor();
        double cornerY = ((double)input.getScreenHeight() - lowerLeftCornerY) * (double)input.getScaleFactor();
        double cutWidth = this.getScissoredArea().width() * input.getScaleFactor();
        double cutHeight = this.getScissoredArea().height() * input.getScaleFactor();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)cornerX), (int)((int)cornerY), (int)((int)cutWidth), (int)((int)cutHeight));
        super.draw(graphics, input);
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    @Override
    public ImmutableList<RectSeeker> getRectSeekers() {
        return this.seekers;
    }

    public static class Seeker
    extends RectSeeker<ScissorableGui> {
        public Seeker() {
        }

        public Seeker(ScissorableGui seekFrom) {
            super(seekFrom);
        }

        @Override
        public ModDim2D dim() {
            return ((ScissorableGui)this.seekFrom).getScissoredArea();
        }
    }
}

