/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.input;

import com.gildedgames.util.ui.input.ButtonState;
import com.gildedgames.util.ui.input.MouseButton;
import com.gildedgames.util.ui.input.MouseInput;
import com.gildedgames.util.ui.input.MouseMotion;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;

public class MouseInputPool
implements Iterable<MouseInput> {
    protected final MouseInput[] events;

    public MouseInputPool(MouseInput ... events) {
        this.events = events;
    }

    public int size() {
        return this.events.length;
    }

    public MouseInput get(int index) {
        if (index >= this.events.length) {
            return null;
        }
        return this.events[index];
    }

    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public boolean containsAll(Object[] a) {
        return this.containsAll(Arrays.asList(a));
    }

    public boolean containsAll(Collection<?> c) {
        return Arrays.asList(this.events).containsAll(c);
    }

    public int indexOf(Object o) {
        return ArrayUtils.indexOf((Object[])this.events, (Object)o);
    }

    public MouseInputPool getFrom(ButtonState state) {
        ArrayList<MouseInput> events = new ArrayList<MouseInput>();
        for (MouseInput event : this) {
            if (event == null || event.getState() != state) continue;
            events.add(event);
        }
        return new MouseInputPool(events.toArray(new MouseInput[events.size()]));
    }

    public MouseInputPool getFrom(MouseButton button) {
        ArrayList<MouseInput> events = new ArrayList<MouseInput>();
        for (MouseInput event : this) {
            if (event == null || event.getButton() != button) continue;
            events.add(event);
        }
        return new MouseInputPool(events.toArray(new MouseInput[events.size()]));
    }

    public MouseInputPool getFrom(MouseMotion motion) {
        ArrayList<MouseInput> events = new ArrayList<MouseInput>();
        for (MouseInput event : this) {
            if (event == null || event.getMotion() != motion) continue;
            events.add(event);
        }
        return new MouseInputPool(events.toArray(new MouseInput[events.size()]));
    }

    public boolean has(MouseMotion motion) {
        for (MouseInput event : this) {
            if (event == null || event.getMotion() != motion) continue;
            return true;
        }
        return false;
    }

    public boolean has(MouseButton button) {
        for (MouseInput event : this) {
            if (event == null || event.getButton() != button) continue;
            return true;
        }
        return false;
    }

    public boolean has(ButtonState state) {
        for (MouseInput event : this) {
            if (event == null || event.getState() != state) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<MouseInput> iterator() {
        return Iterators.forArray((Object[])this.events);
    }
}

