/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.input;

import com.gildedgames.util.ui.input.ButtonState;
import com.gildedgames.util.ui.input.KeyboardInput;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;

public class KeyboardInputPool
implements Iterable<KeyboardInput> {
    protected final KeyboardInput[] events;

    public KeyboardInputPool(KeyboardInput ... events) {
        this.events = events;
    }

    public int size() {
        return this.events.length;
    }

    public KeyboardInput get(int index) {
        if (index >= this.events.length) {
            return null;
        }
        return this.events[index];
    }

    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public boolean containsAll(Collection<?> c) {
        return Arrays.asList(this.events).containsAll(c);
    }

    public int indexOf(Object o) {
        return ArrayUtils.indexOf((Object[])this.events, (Object)o);
    }

    public KeyboardInputPool getFrom(int key) {
        ArrayList<KeyboardInput> events = new ArrayList<KeyboardInput>();
        for (KeyboardInput event : this) {
            if (event == null || event.getKey() != key) continue;
            events.add(event);
        }
        return new KeyboardInputPool(events.toArray(new KeyboardInput[events.size()]));
    }

    public KeyboardInputPool getFrom(char character) {
        ArrayList<KeyboardInput> events = new ArrayList<KeyboardInput>();
        for (KeyboardInput event : this) {
            if (event == null || (char)event.getKey() != character) continue;
            events.add(event);
        }
        return new KeyboardInputPool(events.toArray(new KeyboardInput[events.size()]));
    }

    public KeyboardInputPool getFrom(ButtonState state) {
        ArrayList<KeyboardInput> events = new ArrayList<KeyboardInput>();
        for (KeyboardInput event : this) {
            if (event == null || event.getState() != state) continue;
            events.add(event);
        }
        return new KeyboardInputPool(events.toArray(new KeyboardInput[events.size()]));
    }

    public boolean has(int key) {
        for (KeyboardInput event : this) {
            if (event == null || event.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public boolean has(char character) {
        for (KeyboardInput event : this) {
            if (event == null || (char)event.getKey() != character) continue;
            return true;
        }
        return false;
    }

    public boolean has(ButtonState state) {
        for (KeyboardInput event : this) {
            if (event == null || event.getState() != state) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<KeyboardInput> iterator() {
        return Iterators.forArray((Object[])this.events);
    }
}

