/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.threadedlighting.asm;

import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class TLTransformer
implements IClassTransformer {
    private static final String MCP_NETCLIENTHANDLER = "net.minecraft.client.network.NetHandlerPlayClient";
    private static final String MCP_CHUNKPROVIDERCLIENT = "net.minecraft.client.multiplayer.ChunkProviderClient";
    private static final String MCP_CHUNK = "net.minecraft.world.chunk.Chunk";
    private static final String MCP_WORLDCLIENT = "net.minecraft.client.multiplayer.WorldClient";
    private static final String THREADED_WORLD = "com.gildedgames.util.threadedlighting.world.ThreadedWorld";
    private static final String THREADED_CHUNK = "com.gildedgames.util.threadedlighting.world.ThreadedChunk";

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals(MCP_NETCLIENTHANDLER)) {
            ClassReader classReader = new ClassReader(bytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            this.replaceInstance(classNode, MCP_WORLDCLIENT, THREADED_WORLD);
            ClassWriter cw = new ClassWriter(0);
            classNode.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        if (transformedName.equals(MCP_CHUNKPROVIDERCLIENT)) {
            ClassReader classReader = new ClassReader(bytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            this.replaceInstance(classNode, MCP_CHUNK, THREADED_CHUNK);
            ClassWriter cw = new ClassWriter(0);
            classNode.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        if (transformedName.equals(MCP_CHUNK)) {
            ClassReader classReader = new ClassReader(bytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            MethodNode relightBlock = this.findMethod(classNode, "func_76615_h", "(III)V");
            if (relightBlock == null) {
                relightBlock = this.findMethod(classNode, "relightBlock", "(III)V");
            }
            relightBlock.access = 1;
            MethodNode setBlockIdWithMetadata = this.findMethod(classNode, "func_150807_a", "(IIILnet/minecraft/block/Block;I)Z");
            setBlockIdWithMetadata.access = 1;
            for (AbstractInsnNode insnNode : setBlockIdWithMetadata.instructions) {
                if (!(insnNode instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                if (!methodInsnNode.name.equals(relightBlock.name) || !methodInsnNode.desc.equals(relightBlock.desc)) continue;
                methodInsnNode.setOpcode(182);
            }
            ClassWriter cw = new ClassWriter(3);
            classNode.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        if (name.equals(THREADED_CHUNK)) {
            ClassReader classReader = new ClassReader(bytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            MethodInsnNode mn = (MethodInsnNode)((MethodNode)classNode.methods.get((int)2)).instructions.get(6);
            mn.owner = classNode.superName.replace(".", "/");
            mn.setOpcode(183);
            ClassWriter cw = new ClassWriter(3);
            classNode.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return bytes;
    }

    public MethodNode findMethod(ClassNode classNode, String name, String desc) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(name) || !methodNode.desc.equals(desc)) continue;
            return methodNode;
        }
        return null;
    }

    public void replaceInstance(ClassNode classNode, String oldInstance, String newInstance) {
        oldInstance = oldInstance.replace(".", "/");
        newInstance = newInstance.replace(".", "/");
        for (MethodNode methodNode : classNode.methods) {
            ListIterator iter = methodNode.instructions.iterator();
            TypeInsnNode previousTypeInsnNode = null;
            while (iter.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)iter.next();
                if (node instanceof TypeInsnNode) {
                    TypeInsnNode tn = (TypeInsnNode)node;
                    if (tn.desc.equals(oldInstance)) {
                        previousTypeInsnNode = tn;
                    }
                }
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode mn = (MethodInsnNode)node;
                if (!mn.owner.equals(oldInstance) || !mn.name.equals("<init>")) continue;
                mn.owner = newInstance;
                previousTypeInsnNode.desc = newInstance;
            }
        }
    }
}

