/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.spawning;

import com.gildedgames.util.player.common.player.IPlayerHook;
import com.gildedgames.util.player.common.player.IPlayerProfile;
import com.gildedgames.util.spawning.SpawnAreaPerTick;
import com.gildedgames.util.spawning.SpawnCondition;
import com.gildedgames.util.spawning.SpawnEntry;
import com.gildedgames.util.spawning.SpawnSettings;
import com.gildedgames.util.spawning.util.ChunkMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class SpawnManager {
    private final List<SpawnEntry> genSpawningRegister = new ArrayList<SpawnEntry>();
    private final List<SpawnEntry> tickSpawningRegister = new ArrayList<SpawnEntry>();
    private final List<SpawnCondition> conditionRegister = new ArrayList<SpawnCondition>();
    private ChunkMap<SpawnAreaPerTick> spawnAreaPerTick;
    protected static final Random random = new Random();
    private final SpawnSettings spawnSettings;
    private final int dimensionId;
    private static List<Block> blacklistedBlocks = new ArrayList<Block>();
    private int ticks;

    public SpawnManager(int dimensionId, SpawnSettings spawnSettings) {
        this.spawnSettings = spawnSettings;
        this.dimensionId = dimensionId;
    }

    public void clear() {
        this.spawnAreaPerTick = null;
    }

    public void tickSpawning(World world, Collection<? extends IPlayerHook> playerHooks) {
        boolean doUpdate;
        ++this.ticks;
        boolean bl = doUpdate = this.ticks % this.spawnSettings.ticksBetweenUpdate() == 0;
        if (!doUpdate) {
            return;
        }
        for (IPlayerHook iPlayerHook : playerHooks) {
            IPlayerProfile profile = iPlayerHook.getProfile();
            if (!profile.isLoggedIn()) continue;
            EntityPlayer entityP = profile.getEntity();
            if (entityP.field_71093_bK != this.dimensionId) continue;
            this.wakeUpAreas(world, entityP.field_70165_t, entityP.field_70163_u, entityP.field_70161_v);
        }
        ArrayList<SpawnAreaPerTick> toRemove = new ArrayList<SpawnAreaPerTick>();
        ChunkMap<SpawnAreaPerTick> chunkMap = this.getspawnAreaPerTick();
        for (SpawnAreaPerTick area : chunkMap.getValues()) {
            if (!area.isAwake()) continue;
            area.onUpdate(this.spawnSettings.areaSize(), world);
            if (area.getAmountOfUpdates() % this.spawnSettings.updatesBetweenRespawn() != 0 || !area.noSchedulesLeft()) continue;
            toRemove.add(area);
        }
        for (SpawnAreaPerTick removing : toRemove) {
            chunkMap.remove(removing.getAreaX(), removing.getAreaZ());
        }
    }

    public int getTargetAmountOfEntities(World world, Random random) {
        return (int)Math.round(random.nextGaussian() * (double)this.spawnSettings.amountOfEntitiesInAreaDeviation(world) + (double)this.spawnSettings.averageAmountOfEntitiesInArea(world));
    }

    public int getMaxAmountOfEntitiesIn2x2Area(World world) {
        return this.spawnSettings.maxAmountOfEntitiesIn2x2Area(world);
    }

    private void wakeUpAreas(World world, double posX, double posY, double posZ) {
        int chunkX = MathHelper.func_76128_c((double)posX) >> 4;
        int chunkZ = MathHelper.func_76128_c((double)posZ) >> 4;
        int pAreaX = chunkX / this.spawnSettings.areaSizePerTick();
        int pAreaZ = chunkZ / this.spawnSettings.areaSizePerTick();
        ChunkMap<SpawnAreaPerTick> spawnAreaPerTick = this.getspawnAreaPerTick();
        for (int areaX = pAreaX - 1; areaX <= pAreaX + 1; ++areaX) {
            for (int areaZ = pAreaZ - 1; areaZ <= pAreaZ + 1; ++areaZ) {
                SpawnAreaPerTick spawnArea = spawnAreaPerTick.get(areaX, areaZ);
                if (spawnArea == null) {
                    long randomSeed = world.func_72905_C() + ChunkCoordIntPair.func_77272_a((int)areaX, (int)areaZ);
                    Random random = new Random(randomSeed);
                    ArrayList<SpawnEntry> shuffledRegistered = new ArrayList<SpawnEntry>(this.tickSpawningRegister);
                    Collections.shuffle(shuffledRegistered, random);
                    spawnArea = new SpawnAreaPerTick(this, areaX, areaZ, shuffledRegistered);
                    spawnArea.schedule(world, this.spawnSettings.areaSizePerTick(), this.spawnSettings.groupScattering(), random);
                    spawnAreaPerTick.put(areaX, areaZ, spawnArea);
                }
                spawnArea.wake();
            }
        }
    }

    protected static void registerBlacklistedBlock(Block block) {
        blacklistedBlocks.add(block);
    }

    private ChunkMap<SpawnAreaPerTick> getspawnAreaPerTick() {
        if (this.spawnAreaPerTick == null) {
            this.spawnAreaPerTick = new ChunkMap();
        }
        return this.spawnAreaPerTick;
    }

    public void registerSpawnCondition(SpawnCondition spawnCondition) {
        this.conditionRegister.add(spawnCondition);
    }

    public void registerGenEntry(SpawnEntry spawnEntry) {
        this.genSpawningRegister.add(spawnEntry);
    }

    public void registerPerTickEntry(SpawnEntry spawnEntry) {
        this.tickSpawningRegister.add(spawnEntry);
    }

    public void registerEntry(SpawnEntry spawnEntry) {
        this.genSpawningRegister.add(spawnEntry);
        this.tickSpawningRegister.add(spawnEntry);
    }

    public List<SpawnCondition> getSpawnConditions() {
        return this.conditionRegister;
    }

    public int getMaxSpawnAttempts() {
        return this.spawnSettings.maxSpawnAttempts();
    }

    public int getSpawnDistanceFromPlayer() {
        return this.spawnSettings.spawnDistanceFromPlayer();
    }

    public int getTopSolidOrLiquidBlock(World world, int posX, int posZ) {
        Chunk chunk = world.func_72964_e(posX >> 4, posZ >> 4);
        int x = posX;
        int z = posZ;
        posX &= 0xF;
        posZ &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            Block l = chunk.func_150810_a(posX, k, posZ);
            if (l == Blocks.field_150350_a || !l.func_149688_o().func_76230_c() || l.func_149688_o() == Material.field_151584_j || l.isFoliage((IBlockAccess)world, x, k, z) || blacklistedBlocks.contains(l)) continue;
            return k + 1;
        }
        return -1;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }
}

