/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.nbt;

import com.gildedgames.util.core.nbt.NBTFactory;
import com.gildedgames.util.core.nbt.NBTHelper;
import com.gildedgames.util.io_manager.IOCore;
import com.gildedgames.util.io_manager.exceptions.IOManagerNotFoundException;
import com.gildedgames.util.io_manager.factory.IOBridge;
import com.gildedgames.util.io_manager.io.IO;
import com.gildedgames.util.io_manager.overhead.IOManager;
import net.minecraft.nbt.NBTTagCompound;

public class NBTBridge
implements IOBridge {
    private NBTFactory factory;
    private NBTTagCompound tag;

    public NBTBridge(NBTFactory factory, NBTTagCompound tag) {
        this.factory = factory;
        this.tag = tag;
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.tag.func_74757_a(key, value);
    }

    @Override
    public void setByte(String key, byte value) {
        this.tag.func_74774_a(key, value);
    }

    @Override
    public void setShort(String key, short value) {
        this.tag.func_74777_a(key, value);
    }

    @Override
    public void setInteger(String key, int value) {
        this.tag.func_74768_a(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.tag.func_74772_a(key, value);
    }

    @Override
    public void setFloat(String key, float value) {
        this.tag.func_74776_a(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.tag.func_74780_a(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.tag.func_74778_a(key, value);
    }

    @Override
    public void setByteArray(String key, byte[] value) {
        this.tag.func_74773_a(key, value);
    }

    @Override
    public byte getByte(String key) {
        return this.tag.func_74771_c(key);
    }

    @Override
    public short getShort(String key) {
        return this.tag.func_74765_d(key);
    }

    @Override
    public int getInteger(String key) {
        return this.tag.func_74762_e(key);
    }

    @Override
    public long getLong(String key) {
        return this.tag.func_74763_f(key);
    }

    @Override
    public float getFloat(String key) {
        return this.tag.func_74760_g(key);
    }

    @Override
    public double getDouble(String key) {
        return this.tag.func_74769_h(key);
    }

    @Override
    public String getString(String key) {
        return this.tag.func_74779_i(key);
    }

    @Override
    public byte[] getByteArray(String key) {
        return this.tag.func_74770_j(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.tag.func_74767_n(key);
    }

    @Override
    public byte[] getBytes() {
        return NBTHelper.fromTag(this.tag);
    }

    @Override
    public Class<?> getSerializedClass(String key) {
        String registryID = this.getString("IOManagerID" + key);
        int classID = this.getInteger(key);
        IOManager manager = IOCore.io().getManager(registryID);
        if (manager == null) {
            throw new IOManagerNotFoundException("Manager was not found:" + registryID);
        }
        return manager.getRegistry().getClass(registryID, classID);
    }

    @Override
    public void setSerializedClass(String key, Class<?> classToWrite) {
        IOManager manager = IOCore.io().getManager(classToWrite);
        int classID = manager.getRegistry().getID(classToWrite);
        this.setString("IOManagerID" + key, manager.getID());
        this.setInteger(key, classID);
    }

    @Override
    public void setIO(String key, IO<IOBridge, IOBridge> io) {
    }

    @Override
    public <T extends IO<IOBridge, IOBridge>> T getIO(String key) {
        return null;
    }
}

