/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.gui.util;

import com.gildedgames.util.core.gui.util.GuiFactory;
import com.gildedgames.util.core.gui.util.events.MinecraftHoveredDesc;
import com.gildedgames.util.core.gui.util.wrappers.MinecraftButtonItemStack;
import com.gildedgames.util.core.gui.util.wrappers.MinecraftItemStackRender;
import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.common.Ui;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.util.events.slots.SlotStackFactory;
import com.gildedgames.util.ui.util.factory.ContentFactory;
import com.gildedgames.util.ui.util.factory.Factory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.registry.GameData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class ItemStackButtonFactory<T>
implements ContentFactory<Ui> {
    private StackTypes stackTypes;
    private Function<ItemStack, T> dataFactory;

    public ItemStackButtonFactory(StackTypes stackTypes, Function<ItemStack, T> dataFactory) {
        this.stackTypes = stackTypes;
        this.dataFactory = dataFactory;
    }

    @Override
    public LinkedHashMap<String, Ui> provideContent(ImmutableMap<String, Ui> currentContent, Rect contentArea) {
        LinkedHashMap<String, Ui> buttons = new LinkedHashMap<String, Ui>();
        for (ItemStack stack : this.stackTypes.createStacks()) {
            final MinecraftButtonItemStack button = new MinecraftButtonItemStack(stack);
            button.events().set("description", new MinecraftHoveredDesc(GuiFactory.text(stack.func_82833_r(), Color.WHITE)));
            button.events().set("draggableBehavior", new SlotStackFactory(new Function<T, GuiFrame>(){

                public GuiFrame apply(T input) {
                    return new MinecraftItemStackRender(button.getItemStack());
                }
            }, new Factory<T>(){

                @Override
                public T create() {
                    return ItemStackButtonFactory.this.dataFactory.apply((Object)button.getItemStack());
                }
            }));
            buttons.put(stack.func_77977_a(), button);
        }
        return buttons;
    }

    @Override
    public boolean shouldRefreshContent() {
        return false;
    }

    public static enum StackTypes {
        BLOCKS{

            @Override
            List<ItemStack> createStacks() {
                ArrayList<ItemStack> blockStacks = new ArrayList<ItemStack>();
                for (Block block : GameData.getBlockRegistry().typeSafeIterable()) {
                    Item item;
                    if (block == null || (item = Item.func_150898_a((Block)block)) == null) continue;
                    ArrayList subBlocks = new ArrayList();
                    block.func_149666_a(item, item.func_77640_w(), subBlocks);
                    for (ItemStack stack : subBlocks) {
                        if (stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).field_150939_a == Blocks.field_150350_a) continue;
                        blockStacks.add(stack);
                    }
                }
                return blockStacks;
            }
        }
        ,
        ITEMS{

            @Override
            List<ItemStack> createStacks() {
                return null;
            }
        }
        ,
        ALL{

            @Override
            List<ItemStack> createStacks() {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                stacks.addAll(ITEMS.createStacks());
                stacks.addAll(BLOCKS.createStacks());
                return stacks;
            }
        };


        abstract List<ItemStack> createStacks();
    }
}

