/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.utils;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.electricity.ElectricAdapter;
import net.machinemuse.powersuits.item.ItemComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ElectricItemUtils {
    public static final String MAXIMUM_ENERGY = "Maximum Energy";
    public static final String CURRENT_ENERGY = "Current Energy";

    public static List<ElectricAdapter> electricItemsEquipped(EntityPlayer player) {
        ArrayList<ElectricAdapter> electrics = new ArrayList<ElectricAdapter>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ElectricAdapter adapter = ElectricAdapter.wrap(player.field_71071_by.func_70301_a(i));
            if (adapter == null) continue;
            electrics.add(0, adapter);
        }
        return electrics;
    }

    public static double getPlayerEnergy(EntityPlayer player) {
        double avail = 0.0;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquipped(player)) {
            avail += adapter.getCurrentEnergy();
        }
        return avail;
    }

    public static double getMaxEnergy(EntityPlayer player) {
        double avail = 0.0;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquipped(player)) {
            avail += adapter.getMaxEnergy();
        }
        return avail;
    }

    public static void drainPlayerEnergy(EntityPlayer player, double drainAmount) {
        double drainleft = drainAmount;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquipped(player)) {
            if (!(drainleft > 0.0)) break;
            drainleft -= adapter.drainEnergy(drainleft);
        }
    }

    public static void givePlayerEnergy(EntityPlayer player, double joulesToGive) {
        double joulesleft = joulesToGive;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquipped(player)) {
            if (!(joulesleft > 0.0)) break;
            joulesleft -= adapter.giveEnergy(joulesleft);
        }
    }

    public static double jouleValueOfComponent(ItemStack stackInCost) {
        if (stackInCost.func_77973_b() instanceof ItemComponent) {
            switch (stackInCost.func_77960_j() - ItemComponent.lvcapacitor.func_77960_j()) {
                case 0: {
                    return 20000 * stackInCost.field_77994_a;
                }
                case 1: {
                    return 100000 * stackInCost.field_77994_a;
                }
                case 2: {
                    return 750000 * stackInCost.field_77994_a;
                }
            }
            return 0.0;
        }
        return 0.0;
    }
}

