/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.numina.basemod.NuminaConfig;
import net.machinemuse.numina.sound.Musique;
import net.machinemuse.powersuits.control.PlayerInputMap;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class SwimAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_SWIM_BOOST = "Swim Boost";
    public static final String SWIM_BOOST_AMOUNT = "Underwater Movement Boost";
    public static final String SWIM_BOOST_ENERGY_CONSUMPTION = "Swim Boost Energy Consumption";

    public SwimAssistModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.ionThruster, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 2));
        this.addTradeoffProperty("Thrust", SWIM_BOOST_ENERGY_CONSUMPTION, 100.0, "J");
        this.addTradeoffProperty("Thrust", SWIM_BOOST_AMOUNT, 1.0, "m/s");
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getDataName() {
        return MODULE_SWIM_BOOST;
    }

    @Override
    public String getUnlocalizedName() {
        return "swimAssist";
    }

    @Override
    public String getDescription() {
        return "By refitting an ion thruster for underwater use, you may be able to add extra forward (or backward) thrust when underwater.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (player.func_70090_H() && !player.func_70115_ae()) {
            PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.func_70005_c_());
            boolean jumpkey = movementInput.jumpKey;
            boolean sneakkey = movementInput.sneakKey;
            float forwardkey = movementInput.forwardKey;
            float strafekey = movementInput.strafeKey;
            if (forwardkey != 0.0f || strafekey != 0.0f || jumpkey || sneakkey) {
                double moveRatio = 0.0;
                if (forwardkey != 0.0f) {
                    moveRatio += (double)(forwardkey * forwardkey);
                }
                if (strafekey != 0.0f) {
                    moveRatio += (double)(strafekey * strafekey);
                }
                if (jumpkey || sneakkey) {
                    moveRatio += 0.04000000000000001;
                }
                double swimAssistRate = ModuleManager.computeModularProperty(item, SWIM_BOOST_AMOUNT) * 0.05 * moveRatio;
                double swimEnergyConsumption = ModuleManager.computeModularProperty(item, SWIM_BOOST_ENERGY_CONSUMPTION);
                if (swimEnergyConsumption < ElectricItemUtils.getPlayerEnergy(player)) {
                    if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
                        Musique.playerSound((EntityPlayer)player, (String)"powersuits:SwimAssist", (float)1.0f, (Float)Float.valueOf(1.0f), (Boolean)true);
                    }
                    MusePlayerUtils.thrust(player, swimAssistRate, true);
                } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
                    Musique.stopPlayerSound((EntityPlayer)player, (String)"powersuits:SwimAssist");
                }
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
                Musique.stopPlayerSound((EntityPlayer)player, (String)"powersuits:SwimAssist");
            }
        } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
            Musique.stopPlayerSound((EntityPlayer)player, (String)"powersuits:SwimAssist");
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
            Musique.stopPlayerSound((EntityPlayer)player, (String)"powersuits:SwimAssist");
        }
    }

    @Override
    public String getTextureFile() {
        return "swimboost";
    }
}

