/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import appeng.api.config.AccessRestriction;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.electricity.MuseElectricItem;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.item.IModularItemBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseCommonStrings;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ModularItemBase
extends Item
implements IModularItemBase {
    private static ModularItemBase INSTANCE;

    public static ModularItemBase getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModularItemBase();
        }
        return INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int par2) {
        return this.getColorFromItemStack(itemStack).getInt();
    }

    @Override
    public Colour getGlowFromItemStack(ItemStack itemStack) {
        if (!ModuleManager.itemHasActiveModule(itemStack, "Glow Module")) {
            return Colour.LIGHTBLUE;
        }
        double computedred = ModuleManager.computeModularProperty(itemStack, "Red Glow");
        double computedgreen = ModuleManager.computeModularProperty(itemStack, "Green Glow");
        double computedblue = ModuleManager.computeModularProperty(itemStack, "Blue Glow");
        return new Colour(MuseMathUtils.clampDouble((double)computedred, (double)0.0, (double)1.0), MuseMathUtils.clampDouble((double)computedgreen, (double)0.0, (double)1.0), MuseMathUtils.clampDouble((double)computedblue, (double)0.0, (double)1.0), 0.8);
    }

    @Override
    public Colour getColorFromItemStack(ItemStack itemStack) {
        if (!ModuleManager.itemHasActiveModule(itemStack, "Custom Colour Module")) {
            return Colour.WHITE;
        }
        double computedred = ModuleManager.computeModularProperty(itemStack, "Red Tint");
        double computedgreen = ModuleManager.computeModularProperty(itemStack, "Green Tint");
        double computedblue = ModuleManager.computeModularProperty(itemStack, "Blue Tint");
        return new Colour(MuseMathUtils.clampDouble((double)computedred, (double)0.0, (double)1.0), MuseMathUtils.clampDouble((double)computedgreen, (double)0.0, (double)1.0), MuseMathUtils.clampDouble((double)computedblue, (double)0.0, (double)1.0), 1.0);
    }

    public boolean func_77623_v() {
        return false;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List currentTipList, boolean advancedToolTips) {
        MuseCommonStrings.addInformation(itemStack, player, currentTipList, advancedToolTips);
    }

    @Override
    public String formatInfo(String string, double value) {
        return string + '\t' + MuseStringUtils.formatNumberShort(value);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getLongInfo(EntityPlayer player, ItemStack itemStack) {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Detailed Summary");
        info.add(this.formatInfo("Armor", this.getArmorDouble(player, itemStack)));
        info.add(this.formatInfo("Energy Storage", this.getCurrentEnergy(itemStack)) + 'J');
        info.add(this.formatInfo("Weight", MuseCommonStrings.getTotalWeight(itemStack)) + 'g');
        return info;
    }

    @Override
    public double getArmorDouble(EntityPlayer player, ItemStack itemStack) {
        return 0.0;
    }

    @Override
    public double getPlayerEnergy(EntityPlayer player) {
        return ElectricItemUtils.getPlayerEnergy(player);
    }

    @Override
    public void drainPlayerEnergy(EntityPlayer player, double drainEnergy) {
        ElectricItemUtils.drainPlayerEnergy(player, drainEnergy);
    }

    @Override
    public void givePlayerEnergy(EntityPlayer player, double joulesToGive) {
        ElectricItemUtils.givePlayerEnergy(player, joulesToGive);
    }

    @Override
    public double getCurrentEnergy(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getCurrentEnergy(itemStack);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getCurrentEnergy(itemStack);
    }

    @Override
    public void setCurrentEnergy(ItemStack itemStack, double energy) {
        MuseElectricItem.getInstance().setCurrentEnergy(itemStack, energy);
    }

    @Override
    public double drainEnergyFrom(ItemStack itemStack, double requested) {
        return MuseElectricItem.getInstance().drainEnergyFrom(itemStack, requested);
    }

    @Override
    public double giveEnergyTo(ItemStack itemStack, double provided) {
        return MuseElectricItem.getInstance().giveEnergyTo(itemStack, provided);
    }

    @Override
    public int getMaxDamage(ItemStack itemStack) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getToolTip(ItemStack itemStack) {
        return itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false).toString();
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return MuseElectricItem.getInstance().canProvideEnergy(itemStack);
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getChargedItem(itemStack);
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getEmptyItem(itemStack);
    }

    @Override
    public double getMaxCharge(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getMaxCharge(itemStack);
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getTier(itemStack);
    }

    @Override
    public double getTransferLimit(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getTransferLimit(itemStack);
    }

    @Override
    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return MuseElectricItem.getInstance().charge(itemStack, amount, tier, ignoreTransferLimit, simulate);
    }

    @Override
    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        return MuseElectricItem.getInstance().discharge(itemStack, amount, tier, ignoreTransferLimit, externally, simulate);
    }

    @Override
    public double getCharge(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getCharge(itemStack);
    }

    @Override
    public boolean canUse(ItemStack itemStack, double amount) {
        return MuseElectricItem.getInstance().canUse(itemStack, amount);
    }

    @Override
    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        return MuseElectricItem.getInstance().use(itemStack, amount, entity);
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        MuseElectricItem.getInstance().chargeFromArmor(itemStack, entity);
    }

    @Override
    public IElectricItemManager getManager(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getManager(itemStack);
    }

    @Override
    public int receiveEnergy(ItemStack itemStack, int energy, boolean simulate) {
        return MuseElectricItem.getInstance().receiveEnergy(itemStack, energy, simulate);
    }

    @Override
    public int extractEnergy(ItemStack itemStack, int energy, boolean simulate) {
        return MuseElectricItem.getInstance().extractEnergy(itemStack, energy, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getEnergyStored(itemStack);
    }

    @Override
    public int getMaxEnergyStored(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getMaxEnergyStored(itemStack);
    }

    @Override
    public double injectAEPower(ItemStack itemStack, double ae) {
        return MuseElectricItem.getInstance().injectAEPower(itemStack, ae);
    }

    @Override
    public double extractAEPower(ItemStack itemStack, double ae) {
        return MuseElectricItem.getInstance().extractAEPower(itemStack, ae);
    }

    @Override
    public double getAEMaxPower(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getAEMaxPower(itemStack);
    }

    @Override
    public double getAECurrentPower(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getAECurrentPower(itemStack);
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        return MuseElectricItem.getInstance().getPowerFlow(itemStack);
    }
}

