/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.numina.basemod.NuminaConfig;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.sound.Musique;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;

public class PlayerUpdateHandler {
    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.entity instanceof EntityPlayer) {
            boolean bl;
            EntityPlayer player = (EntityPlayer)e.entity;
            List<ItemStack> modularItemsEquipped = MuseItemUtils.modularItemsEquipped(player);
            double totalWeight = MuseItemUtils.getPlayerWeight(player);
            double weightCapacity = Config.getWeightCapacity();
            for (ItemStack itemStack : modularItemsEquipped) {
                if (!itemStack.func_77978_p().func_74764_b("ench")) continue;
                itemStack.func_77978_p().func_82580_o("ench");
            }
            boolean foundItemWithModule = false;
            for (IPlayerTickModule module : ModuleManager.getPlayerTickModules()) {
                foundItemWithModule = false;
                for (ItemStack itemStack : modularItemsEquipped) {
                    if (!module.isValidForItem(itemStack) || !ModuleManager.itemHasActiveModule(itemStack, module.getDataName())) continue;
                    module.onPlayerTickActive(player, itemStack);
                    foundItemWithModule = true;
                }
                if (foundItemWithModule) continue;
                for (ItemStack itemStack : modularItemsEquipped) {
                    module.onPlayerTickInactive(player, itemStack);
                }
            }
            boolean bl2 = bl = modularItemsEquipped.size() > 0;
            if (bl) {
                player.field_70143_R = (float)MovementManager.computeFallHeightFromVelocity(MuseMathUtils.clampDouble((double)player.field_70181_x, (double)-1000.0, (double)0.0));
                if (totalWeight > weightCapacity) {
                    player.field_70159_w *= weightCapacity / totalWeight;
                    player.field_70179_y *= weightCapacity / totalWeight;
                }
                MuseHeatUtils.coolPlayer(player, MusePlayerUtils.getPlayerCoolingBasedOnMaterial(player));
                double maxHeat = MuseHeatUtils.getMaxHeat(player);
                double currHeat = MuseHeatUtils.getPlayerHeat(player);
                if (currHeat > maxHeat) {
                    player.func_70097_a(MuseHeatUtils.overheatDamage, (float)(Math.sqrt(currHeat - maxHeat) / 4.0));
                    player.func_70015_d(1);
                } else {
                    player.func_70066_B();
                }
                double velsq2 = MuseMathUtils.sumsq((double)player.field_70159_w, (double)player.field_70181_x, (double)player.field_70179_y) - 0.5;
                if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                    if (player.field_70160_al && velsq2 > 0.0) {
                        Musique.playerSound((EntityPlayer)player, (String)"powersuits:Glider", (float)((float)(velsq2 / 3.0)), (Float)Float.valueOf(1.0f), (Boolean)true);
                    } else {
                        Musique.stopPlayerSound((EntityPlayer)player, (String)"powersuits:Glider");
                    }
                }
            } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                Musique.stopPlayerSound((EntityPlayer)player, (String)"powersuits:Glider");
            }
        }
    }
}

