/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import com.google.gson.Gson;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.basemod.Numina;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.powersuits.common.InstallCost;
import net.machinemuse.powersuits.common.MPSCreativeTab;
import net.machinemuse.powersuits.common.MPSItems;
import net.machinemuse.powersuits.common.ModCompatibility;
import net.machinemuse.powersuits.common.proxy.CommonProxy;
import net.machinemuse.powersuits.powermodule.armor.BasicPlatingModule;
import net.machinemuse.powersuits.powermodule.armor.DiamondPlatingModule;
import net.machinemuse.powersuits.powermodule.armor.EnergyShieldModule;
import net.machinemuse.powersuits.powermodule.armor.HeatSinkModule;
import net.machinemuse.powersuits.powermodule.armor.MechanicalAssistance;
import net.machinemuse.powersuits.powermodule.armor.NitrogenCoolingSystem;
import net.machinemuse.powersuits.powermodule.armor.WaterTankModule;
import net.machinemuse.powersuits.powermodule.energy.AdvancedBatteryModule;
import net.machinemuse.powersuits.powermodule.energy.AdvancedSolarGenerator;
import net.machinemuse.powersuits.powermodule.energy.BasicBatteryModule;
import net.machinemuse.powersuits.powermodule.energy.EliteBatteryModule;
import net.machinemuse.powersuits.powermodule.energy.KineticGeneratorModule;
import net.machinemuse.powersuits.powermodule.energy.SolarGeneratorModule;
import net.machinemuse.powersuits.powermodule.energy.ThermalGeneratorModule;
import net.machinemuse.powersuits.powermodule.misc.AutoFeederModule;
import net.machinemuse.powersuits.powermodule.misc.BinocularsModule;
import net.machinemuse.powersuits.powermodule.misc.ClockModule;
import net.machinemuse.powersuits.powermodule.misc.CompassModule;
import net.machinemuse.powersuits.powermodule.misc.CoolingSystemModule;
import net.machinemuse.powersuits.powermodule.misc.CosmeticGlowModule;
import net.machinemuse.powersuits.powermodule.misc.InPlaceAssemblerModule;
import net.machinemuse.powersuits.powermodule.misc.InvisibilityModule;
import net.machinemuse.powersuits.powermodule.misc.MagnetModule;
import net.machinemuse.powersuits.powermodule.misc.MobRepulsorModule;
import net.machinemuse.powersuits.powermodule.misc.NightVisionModule;
import net.machinemuse.powersuits.powermodule.misc.TintModule;
import net.machinemuse.powersuits.powermodule.misc.TransparentArmorModule;
import net.machinemuse.powersuits.powermodule.misc.WaterElectrolyzerModule;
import net.machinemuse.powersuits.powermodule.movement.BlinkDriveModule;
import net.machinemuse.powersuits.powermodule.movement.ClimbAssistModule;
import net.machinemuse.powersuits.powermodule.movement.FlightControlModule;
import net.machinemuse.powersuits.powermodule.movement.GliderModule;
import net.machinemuse.powersuits.powermodule.movement.JetBootsModule;
import net.machinemuse.powersuits.powermodule.movement.JetPackModule;
import net.machinemuse.powersuits.powermodule.movement.JumpAssistModule;
import net.machinemuse.powersuits.powermodule.movement.ParachuteModule;
import net.machinemuse.powersuits.powermodule.movement.ShockAbsorberModule;
import net.machinemuse.powersuits.powermodule.movement.SprintAssistModule;
import net.machinemuse.powersuits.powermodule.movement.SwimAssistModule;
import net.machinemuse.powersuits.powermodule.tool.AquaAffinityModule;
import net.machinemuse.powersuits.powermodule.tool.AxeModule;
import net.machinemuse.powersuits.powermodule.tool.DiamondPickUpgradeModule;
import net.machinemuse.powersuits.powermodule.tool.DimensionalRiftModule;
import net.machinemuse.powersuits.powermodule.tool.FieldTinkerModule;
import net.machinemuse.powersuits.powermodule.tool.FlintAndSteelModule;
import net.machinemuse.powersuits.powermodule.tool.HoeModule;
import net.machinemuse.powersuits.powermodule.tool.LeafBlowerModule;
import net.machinemuse.powersuits.powermodule.tool.LuxCapacitor;
import net.machinemuse.powersuits.powermodule.tool.OreScannerModule;
import net.machinemuse.powersuits.powermodule.tool.PickaxeModule;
import net.machinemuse.powersuits.powermodule.tool.ShearsModule;
import net.machinemuse.powersuits.powermodule.tool.ShovelModule;
import net.machinemuse.powersuits.powermodule.weapon.BladeLauncherModule;
import net.machinemuse.powersuits.powermodule.weapon.LightningModule;
import net.machinemuse.powersuits.powermodule.weapon.MeleeAssistModule;
import net.machinemuse.powersuits.powermodule.weapon.PlasmaCannonModule;
import net.machinemuse.powersuits.powermodule.weapon.RailgunModule;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.input.Keyboard;

public class Config {
    public static final String RESOURCE_PREFIX = "powersuits:";
    public static final String TEXTURE_PREFIX = "powersuits:textures/";
    public static final String SOUND_PREFIX = "powersuits:sound/";
    public static final String LANG_PREFIX = "powersuits:lang/";
    public static final String SEBK_ARMOR_PATH = "powersuits:textures/models/sebkarmor.png";
    public static final String SEBK_ARMORPANTS_PATH = "powersuits:textures/models/sebkarmorpants.png";
    public static final String TINKERTABLE_TEXTURE_PATH = "powersuits:textures/models/tinkertable_tx.png";
    public static final String ARMOR_TEXTURE_PATH = "powersuits:textures/models/diffuse.png";
    public static final String BLANK_ARMOR_MODEL_PATH = "powersuits:textures/models/blankarmor.png";
    public static final String SEBK_TOOL_TEXTURE = "powersuits:textures/models/tool.png";
    public static final String LIGHTNING_TEXTURE = "powersuits:textures/gui/lightning-medium.png";
    public static final String CITIZENJOE_ARMOR_PATH = "powersuits:textures/models/joearmor.png";
    public static final String CITIZENJOE_ARMORPANTS_PATH = "powersuits:textures/models/joearmorpants.png";
    public static final String GLASS_TEXTURE = "powersuits:textures/gui/glass.png";
    static File configFolder = null;
    private static MPSCreativeTab mpsCreativeTab;
    private static Configuration config;
    public static boolean canUseShaders;

    public static boolean keybindHUDon() {
        return config.get("HUD", "Display HUD", true).getBoolean();
    }

    public static double keybindHUDx() {
        return config.get("HUD", "x position", 8.0).getDouble();
    }

    public static double keybindHUDy() {
        return config.get("HUD", "y position", 32.0).getDouble();
    }

    public static boolean toggleModuleSpam() {
        return config.get("HUD", "Chat message when toggling modules", false).getBoolean();
    }

    public static double getWeightCapacity() {
        return config.get("general", "Weight Limit (grams)", 25000.0).getDouble();
    }

    public static void extractRecipes() {
        String key = "Auto-extract recipes";
        if (!config.hasKey("general", key) || config.get("general", key, false).getBoolean()) {
            config.get("general", key, false);
            boolean found = false;
            if (ModCompatibility.isThermalExpansionLoaded()) {
                found = true;
                Config.copyRecipe("mps-thermalexpansion.recipes");
            }
            if (ModCompatibility.isIndustrialCraftLoaded()) {
                found = true;
                Config.copyRecipe("mps-ic2.recipes");
            }
            if (ModCompatibility.isEnderIOLoaded()) {
                found = true;
                Config.copyRecipe("mps-enderio.recipes");
            }
            if (!found) {
                Config.copyRecipe("mps-vanilla.recipes");
            }
        }
    }

    public static void copyRecipe(String inFile) {
        InputStream src = CommonProxy.class.getClassLoader().getResourceAsStream(inFile);
        File dest = new File(Numina.configDir.toString() + "/machinemuse/recipes/" + inFile);
        if (!dest.exists()) {
            try {
                Files.copy(src, dest.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void init(Configuration configuration) {
        config = configuration;
        config.load();
        config.save();
    }

    public static String getNetworkChannelName() {
        return "powerSuits";
    }

    public static CreativeTabs getCreativeTab() {
        if (mpsCreativeTab == null) {
            mpsCreativeTab = new MPSCreativeTab();
        }
        return mpsCreativeTab;
    }

    public static double getSalvageChance() {
        return config.get("general", "Salvage Ratio", 0.9).getDouble(0.9);
    }

    public static double getMaximumArmorPerPiece() {
        return Math.max(0.0, config.get("general", "Maximum Armor per Piece", 6.0).getDouble(6.0));
    }

    public static double getMaximumFlyingSpeedmps() {
        return config.get("general", "Maximum flight speed (in m/s)", 25.0).getDouble(25.0);
    }

    public static boolean useMouseWheel() {
        return config.get("general", "Use Mousewheel to change modes", true).getBoolean(true);
    }

    public static void addModule(IPowerModule module) {
        ModuleManager.addModule(module);
    }

    public static double appengMultiplier() {
        return config.get("general", "Energy per AE", 5.0).getDouble(5.0);
    }

    public static boolean useAdvancedOreScannerMessage() {
        return config.get("general", "Use Detailed Ore Scanner Message", true).getBoolean(true);
    }

    public static boolean useOldAutoFeeder() {
        return config.get("general", "Use Old Auto Feeder Method", false).getBoolean(false);
    }

    public static boolean useCheatyLeatherRecipe() {
        return config.get("general", "Use Cheaty Leather Recipe (Requires Thermal Expansion)", true).getBoolean(true);
    }

    public static boolean useHUDStuff() {
        return config.get("general", "Use HUD for certain modules (Auto Feeder, Compass, Clock, etc.", true).getBoolean(true);
    }

    public static boolean use24hClock() {
        return config.get("general", "Use a 24h clock instead of 12h", false).getBoolean(false);
    }

    public static void loadPowerModules() {
        List<IModularItem> ARMORONLY = Arrays.asList(MPSItems.getInstance().powerArmorHead, MPSItems.getInstance().powerArmorTorso, MPSItems.getInstance().powerArmorLegs, MPSItems.getInstance().powerArmorFeet);
        List<IModularItem> ALLITEMS = Arrays.asList(MPSItems.getInstance().powerArmorHead, MPSItems.getInstance().powerArmorTorso, MPSItems.getInstance().powerArmorLegs, MPSItems.getInstance().powerArmorFeet, MPSItems.getInstance().powerTool);
        List<IModularItem> HEADONLY = Collections.singletonList(MPSItems.getInstance().powerArmorHead);
        List<IModularItem> TORSOONLY = Collections.singletonList(MPSItems.getInstance().powerArmorTorso);
        List<IModularItem> LEGSONLY = Collections.singletonList(MPSItems.getInstance().powerArmorLegs);
        List<IModularItem> FEETONLY = Collections.singletonList(MPSItems.getInstance().powerArmorFeet);
        List<IModularItem> TOOLONLY = Collections.singletonList(MPSItems.getInstance().powerTool);
        Config.addModule(new BasicPlatingModule(ARMORONLY));
        Config.addModule(new DiamondPlatingModule(ARMORONLY));
        Config.addModule(new EnergyShieldModule(ARMORONLY));
        Config.addModule(new HeatSinkModule(ARMORONLY));
        Config.addModule(new AxeModule(TOOLONLY));
        Config.addModule(new PickaxeModule(TOOLONLY));
        Config.addModule(new ShovelModule(TOOLONLY));
        Config.addModule(new ShearsModule(TOOLONLY));
        Config.addModule(new HoeModule(TOOLONLY));
        Config.addModule(new LuxCapacitor(TOOLONLY));
        Config.addModule(new FieldTinkerModule(TOOLONLY));
        Config.addModule(new MeleeAssistModule(TOOLONLY));
        Config.addModule(new PlasmaCannonModule(TOOLONLY));
        Config.addModule(new RailgunModule(TOOLONLY));
        Config.addModule(new BladeLauncherModule(TOOLONLY));
        Config.addModule(new BasicBatteryModule(ALLITEMS));
        Config.addModule(new AdvancedBatteryModule(ALLITEMS));
        Config.addModule(new EliteBatteryModule(ALLITEMS));
        Config.addModule(new ParachuteModule(TORSOONLY));
        Config.addModule(new GliderModule(TORSOONLY));
        Config.addModule(new JetPackModule(TORSOONLY));
        Config.addModule(new SprintAssistModule(LEGSONLY));
        Config.addModule(new JumpAssistModule(LEGSONLY));
        Config.addModule(new SwimAssistModule(LEGSONLY));
        Config.addModule(new ClimbAssistModule(LEGSONLY));
        Config.addModule(new JetBootsModule(FEETONLY));
        Config.addModule(new ShockAbsorberModule(FEETONLY));
        Config.addModule(new WaterElectrolyzerModule(HEADONLY));
        Config.addModule(new NightVisionModule(HEADONLY));
        Config.addModule(new BinocularsModule(HEADONLY));
        Config.addModule(new FlightControlModule(HEADONLY));
        Config.addModule(new InvisibilityModule(TORSOONLY));
        Config.addModule(new BlinkDriveModule(TOOLONLY));
        Config.addModule(new DiamondPickUpgradeModule(TOOLONLY));
        Config.addModule(new AquaAffinityModule(TOOLONLY));
        Config.addModule(new CoolingSystemModule(TORSOONLY));
        Config.addModule(new TintModule(TOOLONLY));
        Config.addModule(new TransparentArmorModule(ARMORONLY));
        Config.addModule(new CosmeticGlowModule(ARMORONLY));
        Config.addModule(new InPlaceAssemblerModule(TOOLONLY));
        Config.addModule(new KineticGeneratorModule(LEGSONLY));
        Config.addModule(new SolarGeneratorModule(HEADONLY));
        Config.addModule(new AutoFeederModule(HEADONLY));
        Config.addModule(new MagnetModule(TORSOONLY));
        Config.addModule(new OreScannerModule(TOOLONLY));
        Config.addModule(new LeafBlowerModule(TOOLONLY));
        Config.addModule(new ThermalGeneratorModule(TORSOONLY));
        Config.addModule(new MobRepulsorModule(TORSOONLY));
        Config.addModule(new FlintAndSteelModule(TOOLONLY));
        Config.addModule(new ClockModule(HEADONLY));
        Config.addModule(new CompassModule(HEADONLY));
        Config.addModule(new LightningModule(TOOLONLY));
        Config.addModule(new WaterTankModule(TORSOONLY));
        Config.addModule(new DimensionalRiftModule(TOOLONLY));
        Config.addModule(new AdvancedSolarGenerator(HEADONLY));
        Config.addModule(new NitrogenCoolingSystem(TORSOONLY));
        Config.addModule(new MechanicalAssistance(TORSOONLY));
    }

    public static Configuration getConfig() {
        return config;
    }

    public static boolean doAdditionalInfo() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && Keyboard.isKeyDown((int)42);
    }

    public static String additionalInfoInstructions() {
        String message = StatCollector.func_74838_a((String)"tooltip.pressShift");
        return MuseStringUtils.wrapMultipleFormatTags(message, new Object[]{MuseStringUtils.FormatCodes.Grey, MuseStringUtils.FormatCodes.Italic});
    }

    public static boolean useGraphicalMeters() {
        return config.get("general", "Use Graphical Meters", true).getBoolean(true);
    }

    public static double baseMaxHeat() {
        return config.get("general", "Base Heat Cap", 50.0).getDouble(50.0);
    }

    public static boolean allowConflictingKeybinds() {
        return config.get("general", "Allow Conflicting Keybinds", true).getBoolean(true);
    }

    public static boolean useCustomFonts() {
        return config.get("Font", "Use Custom Font Engine", true).getBoolean(true);
    }

    public static double fontDetail() {
        return config.get("Font", "Font Detail Multiplier", 4).getDouble(4.0);
    }

    public static String fontURI() {
        return config.get("Font", "Font URI", "powersuits:fonts/cra.ttf").getString();
    }

    public static String fontName() {
        return config.get("Font", "Native Font Name (Overrides URI)", "").getString();
    }

    public static boolean fontAntiAliasing() {
        return config.get("Font", "Font Anti-Aliasing", false).getBoolean(false);
    }

    public static int glowMultiplier() {
        return config.get("Graphics", "Bloom Multiplier", 3).getInt(3);
    }

    public static boolean useShaders() {
        return config.get("Graphics", "Use Pixel/Vertex Shaders", true).getBoolean(true);
    }

    public static void setConfigFolderBase(File folder) {
        configFolder = new File(folder.getAbsolutePath() + "/machinemuse");
    }

    public static void addCustomInstallCosts() {
        try {
            File installCostFile = new File(configFolder, "custominstallcosts.json");
            Gson gson = new Gson();
            if (installCostFile.exists()) {
                InstallCost[] costs;
                DataInputStream is = new DataInputStream(new FileInputStream(installCostFile));
                byte[] bytes = new byte[(int)installCostFile.length()];
                is.readFully(bytes);
                String string = Charset.defaultCharset().decode(ByteBuffer.wrap(bytes)).toString();
                is.close();
                MuseLogger.logDebug((String)string);
                for (InstallCost cost : costs = (InstallCost[])gson.fromJson(string, InstallCost[].class)) {
                    String moduleName = cost.moduleName;
                    Item item = GameRegistry.findItem((String)cost.modId, (String)cost.itemName);
                    if (item != null) {
                        int metadata;
                        int quantity = cost.itemQuantity == null ? 1 : cost.itemQuantity;
                        ItemStack stack = new ItemStack(item, quantity, metadata = cost.itemMetadata == null ? 0 : cost.itemMetadata);
                        if (stack != null) {
                            ModuleManager.addCustomInstallCost(moduleName, stack);
                            continue;
                        }
                        MuseLogger.logError((String)("Invalid Itemstack in custom install cost. Module [" + cost.moduleName + "], item [" + cost.itemName + "]"));
                        continue;
                    }
                    MuseLogger.logError((String)("Invalid Item in custom install cost. Module [" + cost.moduleName + "], item [" + cost.itemName + "]"));
                }
            } else {
                installCostFile.createNewFile();
                InstallCost examplecost = new InstallCost();
                examplecost.moduleName = "Shock Absorber";
                examplecost.itemName = "wool";
                examplecost.modId = "minecraft";
                examplecost.itemQuantity = 2;
                examplecost.itemMetadata = 0;
                InstallCost examplecost2 = new InstallCost();
                examplecost2.moduleName = "Shock Absorber";
                examplecost2.itemName = "powerArmorComponent";
                examplecost2.modId = "powersuits";
                examplecost2.itemQuantity = 2;
                examplecost2.itemMetadata = 2;
                InstallCost[] output = new InstallCost[]{examplecost, examplecost2};
                String json = gson.toJson((Object)output);
                PrintWriter dest = new PrintWriter(installCostFile);
                dest.write(json);
                dest.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        config = null;
        canUseShaders = false;
    }
}

