/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.client.render.modelspec.ModelPartSpec;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.machinemuse.powersuits.client.render.modelspec.MorphTarget;
import net.machinemuse.powersuits.item.ItemPowerArmor;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.WavefrontObject;

public class DefaultModelSpec {
    public static Colour normalcolour = Colour.WHITE;
    public static Colour glowcolour = new Colour(0.06666666666666667, 0.3058823529411765, 1.0, 1.0);
    public static String tex = "/assets/powersuits/textures/models/diffuse.png";

    public static ModelSpec[] loadDefaultModel() {
        ArrayList<ModelSpec> defaultSpecList = new ArrayList<ModelSpec>();
        ModelSpec headModel = DefaultModelSpec.loadModel(new ResourceLocation("powersuits:models/mps_helm.obj"), tex.split(";"));
        DefaultModelSpec.makeEntries(MorphTarget.Head, 0, 0, false, "helm_main;helm_tube_entry1;helm_tubes;helm_tube_entry2".split(";"), headModel);
        DefaultModelSpec.makeEntries(MorphTarget.Head, 0, 1, true, "visor".split(";"), headModel);
        defaultSpecList.add(headModel);
        ModelSpec armsModel = DefaultModelSpec.loadModel(new ResourceLocation("powersuits:models/mps_arms.obj"), tex.split(";"));
        DefaultModelSpec.makeEntries(MorphTarget.RightArm, 1, 0, false, "arms3".split(";"), armsModel);
        DefaultModelSpec.makeEntries(MorphTarget.RightArm, 1, 1, true, "crystal_shoulder_2".split(";"), armsModel);
        DefaultModelSpec.makeEntries(MorphTarget.LeftArm, 1, 0, false, "arms2".split(";"), armsModel);
        DefaultModelSpec.makeEntries(MorphTarget.LeftArm, 1, 1, true, "crystal_shoulder_1".split(";"), armsModel);
        defaultSpecList.add(armsModel);
        ModelSpec bodyModel = DefaultModelSpec.loadModel(new ResourceLocation("powersuits:models/mps_chest.obj"), tex.split(";"));
        DefaultModelSpec.makeEntries(MorphTarget.Body, 1, 0, false, "belt;chest_main;polySurface36;backpack;chest_padding".split(";"), bodyModel);
        DefaultModelSpec.makeEntries(MorphTarget.Body, 1, 1, true, "crystal_belt".split(";"), bodyModel);
        defaultSpecList.add(bodyModel);
        ModelSpec legsModel = DefaultModelSpec.loadModel(new ResourceLocation("powersuits:models/mps_pantaloons.obj"), tex.split(";"));
        DefaultModelSpec.makeEntries(MorphTarget.RightLeg, 2, 0, false, "leg1".split(";"), legsModel);
        DefaultModelSpec.makeEntries(MorphTarget.LeftLeg, 2, 0, false, "leg2".split(";"), legsModel);
        defaultSpecList.add(legsModel);
        ModelSpec feetModel = DefaultModelSpec.loadModel(new ResourceLocation("powersuits:models/mps_boots.obj"), tex.split(";"));
        DefaultModelSpec.makeEntries(MorphTarget.RightLeg, 3, 0, false, "boots1".split(";"), feetModel);
        DefaultModelSpec.makeEntries(MorphTarget.LeftLeg, 3, 0, false, "boots2".split(";"), feetModel);
        defaultSpecList.add(feetModel);
        return (ModelSpec[])defaultSpecList.toArray();
    }

    public static ModelSpec loadModel(ResourceLocation file, String[] textures) {
        WavefrontObject model = ModelRegistry.getInstance().loadModel(file);
        if (model != null) {
            return (ModelSpec)((Object)ModelRegistry.getInstance().put(MuseStringUtils.extractName(file), (Object)new ModelSpec(model, textures, null, null, file.toString())));
        }
        return null;
    }

    public static void makeEntries(MorphTarget target, int slot, int colourIndex, Boolean glow, String[] names, ModelSpec model) {
        for (String name : names) {
            model.put(name, new ModelPartSpec(model, target, name, slot, colourIndex, glow, name));
        }
    }

    public static NBTTagCompound makeModelPrefs(ItemStack stack, int slot) {
        ItemPowerArmor item = (ItemPowerArmor)stack.func_77973_b();
        Colour normalcolour = item.getColorFromItemStack(stack);
        Colour glowcolour = item.getGlowFromItemStack(stack);
        ArrayList<NBTTagCompound> list = new ArrayList<NBTTagCompound>();
        switch (slot) {
            case 0: {
                list.addAll(DefaultModelSpec.makePrefs("mps_helm", "helm_main;helm_tube_entry1;helm_tubes;helm_tube_entry2".split(";"), 0, false));
                list.addAll(DefaultModelSpec.makePrefs("mps_helm", "visor".split(";"), 1, true));
                break;
            }
            case 1: {
                list.addAll(DefaultModelSpec.makePrefs("mps_arms", "arms2;arms3".split(";"), 0, false));
                list.addAll(DefaultModelSpec.makePrefs("mps_arms", "crystal_shoulder_2;crystal_shoulder_1".split(";"), 1, true));
                list.addAll(DefaultModelSpec.makePrefs("mps_chest", "belt;chest_main;polySurface36;backpack;chest_padding".split(";"), 0, false));
                list.addAll(DefaultModelSpec.makePrefs("mps_chest", "crystal_belt".split(";"), 1, true));
                break;
            }
            case 2: {
                list.addAll(DefaultModelSpec.makePrefs("mps_pantaloons", "leg1;leg2".split(";"), 0, false));
                break;
            }
            case 3: {
                list.addAll(DefaultModelSpec.makePrefs("mps_boots", "boots1;boots2".split(";"), 0, false));
            }
        }
        NBTTagCompound nbt = new NBTTagCompound();
        for (NBTTagCompound elem : list) {
            nbt.func_74782_a(elem.func_74779_i("model") + "." + elem.func_74779_i("part"), (NBTBase)elem);
        }
        return nbt;
    }

    public static List<NBTTagCompound> makePrefs(String modelname, String[] partnames, int colour, boolean glow) {
        ArrayList<NBTTagCompound> prefArray = new ArrayList<NBTTagCompound>();
        ModelSpec model = (ModelSpec)((Object)ModelRegistry.getInstance().get(modelname));
        for (String name : partnames) {
            prefArray.add(DefaultModelSpec.makePref((ModelPartSpec)model.get(name), colour, glow));
        }
        return prefArray;
    }

    public static NBTTagCompound makePref(ModelPartSpec partSpec, Integer colourindex, Boolean glow) {
        return partSpec.multiSet(new NBTTagCompound(), null, glow, colourindex);
    }
}

