/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.general.gui.clickable.ClickableSlider;
import net.machinemuse.general.gui.frame.IGuiFrame;
import net.machinemuse.general.gui.frame.ItemSelectionFrame;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.DrawableMuseRect;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.numina.geometry.MuseRect;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.numina.network.PacketSender;
import net.machinemuse.powersuits.item.ItemPowerArmor;
import net.machinemuse.powersuits.network.packets.MusePacketColourInfo;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.render.GuiIcons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.ArrayUtils;

public class ColourPickerFrame
implements IGuiFrame {
    public ItemSelectionFrame itemSelector;
    public DrawableMuseRect border;
    public ClickableSlider rslider;
    public ClickableSlider gslider;
    public ClickableSlider bslider;
    public ClickableSlider selectedSlider;
    public int selectedColour;
    public int decrAbove;

    public ColourPickerFrame(MuseRect borderRef, Colour insideColour, Colour borderColour, ItemSelectionFrame itemSelector) {
        this.itemSelector = itemSelector;
        this.border = new DrawableMuseRect(borderRef, insideColour, borderColour);
        this.rslider = new ClickableSlider(new MusePoint2D(this.border.centerx(), this.border.top() + 8.0), this.border.width() - 10.0, StatCollector.func_74838_a((String)"gui.red"));
        this.gslider = new ClickableSlider(new MusePoint2D(this.border.centerx(), this.border.top() + 24.0), this.border.width() - 10.0, StatCollector.func_74838_a((String)"gui.green"));
        this.bslider = new ClickableSlider(new MusePoint2D(this.border.centerx(), this.border.top() + 40.0), this.border.width() - 10.0, StatCollector.func_74838_a((String)"gui.blue"));
        this.selectedSlider = null;
        this.selectedColour = 0;
        this.decrAbove = -1;
    }

    public int[] colours() {
        return this.getOrCreateColourTag() != null ? this.getOrCreateColourTag().func_150302_c() : new int[]{};
    }

    public NBTTagIntArray getOrCreateColourTag() {
        if (this.itemSelector.getSelectedItem() == null) {
            return null;
        }
        NBTTagCompound renderSpec = MuseItemUtils.getMuseRenderTag(this.itemSelector.getSelectedItem().getItem());
        if (renderSpec.func_74764_b("colours") && renderSpec.func_74781_a("colours") instanceof NBTTagIntArray) {
            return (NBTTagIntArray)renderSpec.func_74781_a("colours");
        }
        Item item = this.itemSelector.getSelectedItem().getItem().func_77973_b();
        if (item instanceof ItemPowerArmor) {
            ItemPowerArmor itemPowerArmor = (ItemPowerArmor)item;
            int[] intArray = new int[]{itemPowerArmor.getColorFromItemStack(this.itemSelector.getSelectedItem().getItem()).getInt(), itemPowerArmor.getGlowFromItemStack(this.itemSelector.getSelectedItem().getItem()).getInt()};
            renderSpec.func_74783_a("colours", intArray);
        } else {
            int[] intArray2 = new int[]{};
            renderSpec.func_74783_a("colours", intArray2);
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_70170_p.field_72995_K) {
            PacketSender.sendToServer((MusePacket)new MusePacketColourInfo((EntityPlayer)player, this.itemSelector.getSelectedItem().inventorySlot, this.colours()));
        }
        return (NBTTagIntArray)renderSpec.func_74781_a("colours");
    }

    public NBTTagIntArray setColourTagMaybe(int[] newarray) {
        if (this.itemSelector.getSelectedItem() == null) {
            return null;
        }
        NBTTagCompound renderSpec = MuseItemUtils.getMuseRenderTag(this.itemSelector.getSelectedItem().getItem());
        renderSpec.func_74782_a("colours", (NBTBase)new NBTTagIntArray(newarray));
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_70170_p.field_72995_K) {
            PacketSender.sendToServer((MusePacket)new MusePacketColourInfo((EntityPlayer)player, this.itemSelector.getSelectedItem().inventorySlot, this.colours()));
        }
        return (NBTTagIntArray)renderSpec.func_74781_a("colours");
    }

    public ArrayList<Integer> importColours() {
        return new ArrayList<Integer>();
    }

    public void refreshColours() {
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
        this.selectedSlider = null;
    }

    @Override
    public void update(double mousex, double mousey) {
        if (this.selectedSlider != null) {
            this.selectedSlider.setValueByX(mousex);
            if (this.colours().length > this.selectedColour) {
                this.colours()[this.selectedColour] = Colour.getInt((double)this.rslider.value(), (double)this.gslider.value(), (double)this.bslider.value(), (double)1.0);
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                if (player.field_70170_p.field_72995_K) {
                    PacketSender.sendToServer((MusePacket)new MusePacketColourInfo((EntityPlayer)player, this.itemSelector.getSelectedItem().inventorySlot, this.colours()));
                }
            }
        }
    }

    @Override
    public void draw() {
        this.border.draw();
        this.rslider.draw();
        this.gslider.draw();
        this.bslider.draw();
        for (int i = 0; i < this.colours().length; ++i) {
            new GuiIcons.ArmourColourPatch(this.border.left() + 8.0 + (double)(i * 8), this.border.bottom() - 16.0, new Colour(this.colours()[i]), null, null, null, null);
        }
        new GuiIcons.ArmourColourPatch(this.border.left() + 8.0 + (double)(this.colours().length * 8), this.border.bottom() - 16.0, Colour.WHITE, null, null, null, null);
        new GuiIcons.SelectedArmorOverlay(this.border.left() + 8.0 + (double)(this.selectedColour * 8), this.border.bottom() - 16.0, Colour.WHITE, null, null, null, null);
        new GuiIcons.MinusSign(this.border.left() + 8.0 + (double)(this.selectedColour * 8), this.border.bottom() - 24.0, Colour.RED, null, null, null, null);
        new GuiIcons.PlusSign(this.border.left() + 8.0 + (double)(this.colours().length * 8), this.border.bottom() - 16.0, Colour.GREEN, null, null, null, null);
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        return null;
    }

    public void onSelectColour(int i) {
        Colour c = new Colour(this.colours()[i]);
        this.rslider.setValue(c.r);
        this.gslider.setValue(c.g);
        this.bslider.setValue(c.b);
        this.selectedColour = i;
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
        NBTTagIntArray nbtTagIntArray;
        int[] intArray;
        this.selectedSlider = this.rslider.hitBox(x, y) ? this.rslider : (this.gslider.hitBox(x, y) ? this.gslider : (this.bslider.hitBox(x, y) ? this.bslider : null));
        if (y > this.border.bottom() - 16.0 && y < this.border.bottom() - 8.0) {
            int colourCol = (int)(x - this.border.left() - 8.0) / 8;
            if (colourCol >= 0 && colourCol < this.colours().length) {
                this.onSelectColour(colourCol);
            } else if (colourCol == this.colours().length) {
                MuseLogger.logDebug((String)"Adding");
                NBTTagIntArray nbtTagIntArray2 = this.getOrCreateColourTag();
                int[] intArray2 = this.getIntArray(nbtTagIntArray2);
                this.setColourTagMaybe(ArrayUtils.add((int[])intArray2, (int)Colour.WHITE.getInt()));
            }
        }
        if (y > this.border.bottom() - 24.0 && y < this.border.bottom() - 16.0 && x > this.border.left() + 8.0 + (double)(this.selectedColour * 8) && x < this.border.left() + 16.0 + (double)(this.selectedColour * 8) && (intArray = this.getIntArray(nbtTagIntArray = this.getOrCreateColourTag())) != null && intArray.length > 1) {
            ArrayList<Integer> integerArray = new ArrayList<Integer>();
            int intToRemove = intArray[this.selectedColour];
            for (int anIntArray : intArray) {
                if (anIntArray == intToRemove) continue;
                integerArray.add(anIntArray);
            }
            int[] newIntArray = new int[integerArray.size()];
            int j = 0;
            for (Integer i : integerArray) {
                newIntArray[j] = i;
                ++j;
            }
            this.setColourTagMaybe(newIntArray);
            this.decrAbove = this.selectedColour;
            if (this.selectedColour == this.getIntArray(nbtTagIntArray).length) {
                --this.selectedColour;
            }
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player.field_70170_p.field_72995_K) {
                PacketSender.sendToServer((MusePacket)new MusePacketColourInfo((EntityPlayer)player, this.itemSelector.getSelectedItem().inventorySlot, nbtTagIntArray.func_150302_c()));
            }
        }
    }

    public int[] getIntArray(NBTTagIntArray e) {
        if (e == null) {
            return new int[0];
        }
        return e.func_150302_c();
    }
}

