/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.handler;

import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.FeatureRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class OverlayHandler {
    public static Map overlayMap = new HashMap();

    public static void init() {
        for (String name : FeatureRegistry.overlayItems) {
            String itemName = name.substring(0, name.indexOf(":"));
            if (overlayMap.containsKey(itemName)) continue;
            String overlayType = name.substring(name.indexOf(":") + 1).toLowerCase();
            if (overlayType.equals("grass")) {
                overlayMap.put(itemName, Overlay.GRASS);
                continue;
            }
            if (overlayType.equals("snow")) {
                overlayMap.put(itemName, Overlay.SNOW);
                continue;
            }
            if (overlayType.equals("web")) {
                overlayMap.put(itemName, Overlay.WEB);
                continue;
            }
            if (overlayType.equals("vine")) {
                overlayMap.put(itemName, Overlay.VINE);
                continue;
            }
            if (overlayType.equals("hay")) {
                overlayMap.put(itemName, Overlay.HAY);
                continue;
            }
            if (!overlayType.equals("mycelium")) continue;
            overlayMap.put(itemName, Overlay.MYCELIUM);
        }
    }

    public static boolean coversFullSide(Overlay overlay, int side) {
        switch (overlay) {
            case GRASS: 
            case SNOW: 
            case HAY: 
            case MYCELIUM: {
                return side == 1;
            }
            case WEB: 
            case VINE: {
                return true;
            }
        }
        return true;
    }

    public static Overlay getOverlayType(ItemStack itemStack) {
        Object object = overlayMap.get(itemStack.func_82833_r());
        if (object == null) {
            object = overlayMap.get(ChatHandler.getDefaultTranslation(itemStack));
        }
        return object == null ? Overlay.NONE : (Overlay)((Object)object);
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getOverlayIcon(Overlay overlay, int side) {
        Block block = BlockProperties.toBlock(overlay.getItemStack());
        switch (overlay) {
            case GRASS: 
            case SNOW: 
            case HAY: 
            case MYCELIUM: {
                switch (side) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return block.func_149733_h(1);
                    }
                }
                switch (overlay) {
                    case GRASS: {
                        return RenderBlocks.field_147843_b ? BlockGrass.func_149990_e() : IconRegistry.icon_overlay_fast_grass_side;
                    }
                    case SNOW: {
                        return IconRegistry.icon_overlay_snow_side;
                    }
                    case HAY: {
                        return IconRegistry.icon_overlay_hay_side;
                    }
                    case MYCELIUM: {
                        return IconRegistry.icon_overlay_mycelium_side;
                    }
                }
                return null;
            }
            case WEB: 
            case VINE: {
                return block.func_149733_h(side);
            }
        }
        return null;
    }

    public static enum Overlay {
        NONE(new ItemStack(Blocks.field_150350_a)),
        GRASS(new ItemStack((Block)Blocks.field_150349_c)),
        SNOW(new ItemStack(Blocks.field_150433_aE)),
        WEB(new ItemStack(Blocks.field_150321_G)),
        VINE(new ItemStack(Blocks.field_150395_bd)),
        HAY(new ItemStack(Blocks.field_150407_cf)),
        MYCELIUM(new ItemStack((Block)Blocks.field_150391_bh));

        private ItemStack itemStack;

        private Overlay(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }
}

