/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

public class MathVector {
    public double X;
    public double Y;
    public double Z;

    public static MathVector getFromAngles(double Yaw, double Pitch) {
        MathVector vector = new MathVector();
        vector.X = Math.cos(Yaw) * Math.cos(Pitch);
        vector.Y = Math.sin(Pitch);
        vector.Z = Math.sin(Yaw) * Math.cos(Pitch);
        return vector;
    }

    public MathVector multiply(double i) {
        this.X *= i;
        this.Y *= i;
        this.Z *= i;
        return this;
    }

    public double abs() {
        return Math.hypot(this.X, Math.hypot(this.Y, this.Z));
    }

    public MathVector add(MathVector vector, double factor) {
        MathVector lVector = vector.clone().makeVectorLength(factor);
        this.X += lVector.X;
        this.Y += lVector.Y;
        this.Z += lVector.Z;
        return this;
    }

    public MathVector add(MathVector vector) {
        this.X += vector.X;
        this.Y += vector.Y;
        this.Z += vector.Z;
        return this;
    }

    public MathVector reverse() {
        this.X = -this.X;
        this.Y = -this.Y;
        this.Z = -this.Z;
        return this;
    }

    public MathVector getOrtogonal(Double pX, Double pY, Double pZ) {
        if (pX != null && pY != null && pZ != null || pX == null && pY == null || pY == null && pZ == null || pX == null && pZ == null) {
            throw new UnsupportedOperationException("One, only one parameter needs to be null");
        }
        MathVector answer = new MathVector();
        if (pX == null) {
            answer.X = (-pY.doubleValue() * this.Y - pZ * this.Z) / this.X;
            answer.Y = pY;
            answer.Z = pZ;
        } else if (pY == null) {
            answer.X = pX;
            answer.Y = (-pX.doubleValue() * this.X - pZ * this.Z) / this.Y;
            answer.Z = pZ;
        } else if (pZ == null) {
            answer.X = pX;
            answer.Y = pY;
            answer.Z = (-pX.doubleValue() * this.X - pY * this.Y) / this.Z;
        }
        return answer;
    }

    public MathVector makeVectorLength(double length) {
        double divide = Math.sqrt(Math.pow(this.abs(), 2.0) / Math.pow(length, 2.0));
        double multiply = 1.0 / divide;
        this.X *= multiply;
        this.Y *= multiply;
        this.Z *= multiply;
        return this;
    }

    public String toString() {
        return "[" + this.X + "," + this.Y + "," + this.Z + "]" + "(" + this.abs() + ")";
    }

    public MathVector clone() {
        MathVector vector = new MathVector();
        vector.X = this.X;
        vector.Y = this.Y;
        vector.Z = this.Z;
        return vector;
    }
}

