/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayedGeneric<T>
implements Delayed {
    private final long origin = System.nanoTime();
    private final long delay;
    private final T workItem;

    public DelayedGeneric(T workItem, long delay) {
        this.workItem = workItem;
        this.delay = delay * 1000L;
    }

    public T get() {
        return this.workItem;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.delay - (System.nanoTime() - this.origin), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed == this) {
            return 0;
        }
        if (delayed instanceof DelayedGeneric) {
            long diff = this.delay + this.origin - (((DelayedGeneric)delayed).delay + ((DelayedGeneric)delayed).origin);
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
        long d = this.getDelay(TimeUnit.NANOSECONDS) - delayed.getDelay(TimeUnit.NANOSECONDS);
        return d == 0L ? 0 : (d < 0L ? -1 : 1);
    }

    public String toString() {
        return "DelayedGeneric[" + this.workItem.toString() + ", (" + this.delay + ", " + this.getDelay(TimeUnit.MILLISECONDS) + ")]";
    }
}

