/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.routing.order.IOrderInfoProvider;

public class LinkedLogisticsOrderList
extends ArrayList<IOrderInfoProvider> {
    private static final long serialVersionUID = 4328359512757178338L;
    private List<LinkedLogisticsOrderList> subOrders = new ArrayList<LinkedLogisticsOrderList>();
    private List<IOrderInfoProvider> cachedList = null;
    private List<Float> cachedProgress = null;

    private void generateCache() {
        this.cachedList = new ArrayList<IOrderInfoProvider>();
        this.cachedList.addAll(this);
        for (LinkedLogisticsOrderList sub : this.subOrders) {
            this.cachedList.addAll(sub.getList());
        }
    }

    public List<IOrderInfoProvider> getList() {
        if (this.cachedList == null) {
            this.generateCache();
        }
        return this.cachedList;
    }

    public int getTreeRootSize() {
        int subSize = 0;
        for (LinkedLogisticsOrderList sub : this.subOrders) {
            subSize += sub.getTreeRootSize();
        }
        return Math.max(this.size(), subSize);
    }

    public int getSubTreeRootSize() {
        int subSize = 0;
        for (LinkedLogisticsOrderList sub : this.subOrders) {
            subSize += sub.getTreeRootSize();
        }
        return subSize;
    }

    public void setWatched() {
        for (IOrderInfoProvider order : this) {
            order.setWatched();
        }
        for (LinkedLogisticsOrderList sub : this.subOrders) {
            sub.setWatched();
        }
    }

    private void createProgressCache() {
        this.cachedProgress = new ArrayList<Float>();
        for (IOrderInfoProvider order : this) {
            for (Float n : order.getProgresses()) {
                if (this.cachedProgress.contains(n)) continue;
                this.cachedProgress.add(n);
            }
        }
    }

    public List<Float> getProgresses() {
        if (this.cachedProgress == null) {
            this.createProgressCache();
        }
        return this.cachedProgress;
    }

    public List<LinkedLogisticsOrderList> getSubOrders() {
        return this.subOrders;
    }
}

