/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IProvide;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.IPromise;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.utils.FinalPair;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.IHavePriority;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;

public class RequestTree
extends RequestTreeNode {
    public static final EnumSet<ActiveRequestType> defaultRequestFlags = EnumSet.of(ActiveRequestType.Provide, ActiveRequestType.Craft);
    private HashMap<FinalPair<IProvide, ItemIdentifier>, Integer> _promisetotals;

    public RequestTree(IResource requestType, RequestTree parent, EnumSet<ActiveRequestType> requestFlags, IAdditionalTargetInformation info) {
        super(requestType, parent, requestFlags, info);
    }

    private int getExistingPromisesFor(FinalPair<IProvide, ItemIdentifier> key) {
        Integer n;
        if (this._promisetotals == null) {
            this._promisetotals = new HashMap();
        }
        if ((n = this._promisetotals.get(key)) == null) {
            return 0;
        }
        return n;
    }

    public int getAllPromissesFor(IProvide provider, ItemIdentifier item) {
        FinalPair<IProvide, ItemIdentifier> key = new FinalPair<IProvide, ItemIdentifier>(provider, item);
        return this.getExistingPromisesFor(key);
    }

    public LinkedList<IExtraPromise> getExtrasFor(IResource item) {
        HashMap<IProvide, List<IExtraPromise>> extraMap = new HashMap<IProvide, List<IExtraPromise>>();
        this.checkForExtras(item, extraMap);
        this.removeUsedExtras(item, extraMap);
        LinkedList<IExtraPromise> extras = new LinkedList<IExtraPromise>();
        for (List<IExtraPromise> sublist : extraMap.values()) {
            extras.addAll(sublist);
        }
        return extras;
    }

    protected LinkedLogisticsOrderList fullFillAll() {
        return this.fullFill();
    }

    public void sendMissingMessage(RequestLog log) {
        HashMap<IResource, Integer> missing = new HashMap<IResource, Integer>();
        this.buildMissingMap(missing);
        log.handleMissingItems(RequestTreeNode.shrinkToList(missing));
    }

    public void sendUsedMessage(RequestLog log) {
        HashMap<IResource, Integer> used = new HashMap<IResource, Integer>();
        HashMap<IResource, Integer> missing = new HashMap<IResource, Integer>();
        this.buildUsedMap(used, missing);
        log.handleSucessfullRequestOfList(RequestTreeNode.shrinkToList(used), new LinkedLogisticsOrderList());
        log.handleMissingItems(RequestTreeNode.shrinkToList(missing));
    }

    protected void promiseAdded(IPromise promise) {
        FinalPair<IProvide, ItemIdentifier> key = new FinalPair<IProvide, ItemIdentifier>(promise.getProvider(), promise.getItemType());
        if (this._promisetotals == null) {
            this._promisetotals = new HashMap();
        }
        this._promisetotals.put(key, this.getExistingPromisesFor(key) + promise.getAmount());
    }

    protected void promiseRemoved(IPromise promise) {
        FinalPair<IProvide, ItemIdentifier> key = new FinalPair<IProvide, ItemIdentifier>(promise.getProvider(), promise.getItemType());
        int r = this.getExistingPromisesFor(key) - promise.getAmount();
        if (r == 0) {
            this._promisetotals.remove(key);
        } else {
            this._promisetotals.put(key, r);
        }
    }

    public static boolean request(List<ItemIdentifierStack> items, IRequestItems requester, RequestLog log, EnumSet<ActiveRequestType> requestFlags, IAdditionalTargetInformation info) {
        HashMap<IResource, Integer> messages = new HashMap<IResource, Integer>();
        RequestTree tree = new RequestTree((IResource)new ItemResource(new ItemIdentifierStack(ItemIdentifier.get(Item.func_150898_a((Block)Blocks.field_150348_b), 0, null), 0), requester), null, requestFlags, info);
        boolean isDone = true;
        for (ItemIdentifierStack stack : items) {
            ItemIdentifier item = stack.getItem();
            Integer count = (Integer)messages.get(item);
            if (count == null) {
                count = 0;
            }
            count = count + stack.getStackSize();
            ItemResource req = new ItemResource(stack, requester);
            messages.put(req, count);
            RequestTree node = new RequestTree((IResource)req, tree, requestFlags, info);
            isDone = isDone && node.isDone();
        }
        if (isDone) {
            LinkedLogisticsOrderList list = tree.fullFillAll();
            if (log != null) {
                log.handleSucessfullRequestOfList(RequestTreeNode.shrinkToList(messages), list);
            }
            return true;
        }
        if (log != null) {
            tree.logFailedRequestTree(log);
        }
        return false;
    }

    public static int request(ItemIdentifierStack item, IRequestItems requester, RequestLog log, boolean acceptPartial, boolean simulateOnly, boolean logMissing, boolean logUsed, EnumSet<ActiveRequestType> requestFlags, IAdditionalTargetInformation info) {
        ItemResource req = new ItemResource(item, requester);
        RequestTree tree = new RequestTree((IResource)req, null, requestFlags, info);
        if (!simulateOnly && (tree.isDone() || tree.getPromiseAmount() > 0 && acceptPartial)) {
            LinkedLogisticsOrderList list = tree.fullFillAll();
            if (log != null) {
                log.handleSucessfullRequestOf(req.copyForDisplayWith(item.getStackSize()), list);
            }
            return tree.getPromiseAmount();
        }
        if (log != null) {
            if (!tree.isDone()) {
                tree.recurseFailedRequestTree();
            }
            if (logMissing) {
                tree.sendMissingMessage(log);
            }
            if (logUsed) {
                tree.sendUsedMessage(log);
            }
        }
        return tree.getPromiseAmount();
    }

    public static boolean request(ItemIdentifierStack item, IRequestItems requester, RequestLog log, IAdditionalTargetInformation info) {
        return RequestTree.request(item, requester, log, false, false, true, false, defaultRequestFlags, info) == item.getStackSize();
    }

    public static int requestPartial(ItemIdentifierStack item, IRequestItems requester, IAdditionalTargetInformation info) {
        return RequestTree.request(item, requester, null, true, false, true, false, defaultRequestFlags, info);
    }

    public static int simulate(ItemIdentifierStack item, IRequestItems requester, RequestLog log) {
        return RequestTree.request(item, requester, log, true, true, false, true, defaultRequestFlags, null);
    }

    public static int requestFluidPartial(FluidIdentifier liquid, int amount, IRequestFluid pipe, RequestLog log) {
        return RequestTree.requestFluid(liquid, amount, pipe, log, true);
    }

    public static boolean requestFluid(FluidIdentifier liquid, int amount, IRequestFluid pipe, RequestLog log) {
        return RequestTree.requestFluid(liquid, amount, pipe, log, false) == amount;
    }

    private static int requestFluid(FluidIdentifier liquid, int amount, IRequestFluid pipe, RequestLog log, boolean acceptPartial) {
        FluidResource req = new FluidResource(liquid, amount, pipe);
        RequestTree request = new RequestTree((IResource)req, null, defaultRequestFlags, null);
        if (request.isDone() || acceptPartial) {
            request.fullFill();
            if (log != null) {
                log.handleSucessfullRequestOf(req.copyForDisplayWith(req.getRequestedAmount()), null);
            }
            return request.getPromiseAmount();
        }
        if (log != null) {
            request.sendMissingMessage(log);
        }
        return request.getPromiseAmount();
    }

    public static class workWeightedSorter
    implements Comparator<ExitRoute> {
        public final double distanceWeight;

        public workWeightedSorter(double distanceWeight) {
            this.distanceWeight = distanceWeight;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ExitRoute o1, ExitRoute o2) {
            int c = 0;
            if (o1.destination.getPipe() instanceof IHavePriority) {
                if (!(o2.destination.getPipe() instanceof IHavePriority)) return -1;
                c = ((IHavePriority)((Object)o2.destination.getCachedPipe())).getPriority() - ((IHavePriority)((Object)o1.destination.getCachedPipe())).getPriority();
                if (c != 0) {
                    return c;
                }
            } else if (o2.destination.getPipe() instanceof IHavePriority) {
                return 1;
            }
            c = (int)Math.floor(o1.destination.getCachedPipe().getLoadFactor() * 64.0) - (int)Math.floor(o2.destination.getCachedPipe().getLoadFactor() * 64.0);
            if (this.distanceWeight == 0.0) return c;
            return (int)((double)c + (double)((int)(Math.floor(o1.distanceToDestination * 64.0) - (double)((int)Math.floor(o2.distanceToDestination * 64.0)))) * this.distanceWeight);
        }
    }

    public static enum ActiveRequestType {
        Provide,
        Craft,
        AcceptPartial,
        SimulateOnly,
        LogMissing,
        LogUsed;

    }
}

