/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.IReqCraftingTemplate;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;

public class ItemCraftingTemplate
implements IReqCraftingTemplate {
    protected ItemIdentifierStack _result;
    protected ICraftItems _crafter;
    protected ArrayList<Pair<IResource, IAdditionalTargetInformation>> _required = new ArrayList(9);
    protected ArrayList<ItemIdentifierStack> _byproduct = new ArrayList(9);
    private final int priority;

    public ItemCraftingTemplate(ItemIdentifierStack result, ICraftItems crafter, int priority) {
        this._result = result;
        this._crafter = crafter;
        this.priority = priority;
    }

    @Override
    public void addRequirement(IResource requirement, IAdditionalTargetInformation info) {
        this._required.add(new Pair<IResource, IAdditionalTargetInformation>(requirement, info));
    }

    @Override
    public void addByproduct(ItemIdentifierStack stack) {
        for (ItemIdentifierStack i : this._byproduct) {
            if (!i.getItem().equals(stack.getItem())) continue;
            i.setStackSize(i.getStackSize() + stack.getStackSize());
            return;
        }
        this._byproduct.add(stack);
    }

    @Override
    public LogisticsPromise generatePromise(int nResultSets) {
        return new LogisticsPromise(this._result.getItem(), this._result.getStackSize() * nResultSets, this._crafter, IOrderInfoProvider.ResourceType.CRAFTING);
    }

    @Override
    public ICraftItems getCrafter() {
        return this._crafter;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(ICraftingTemplate o) {
        int c = o.comparePriority(this.priority);
        if (c == 0) {
            c = o.compareStack(this._result);
        }
        if (c == 0) {
            c = o.compareCrafter(this._crafter);
        }
        return c;
    }

    @Override
    public int comparePriority(int priority) {
        return priority - this.priority;
    }

    @Override
    public int compareStack(ItemIdentifierStack stack) {
        return stack.compareTo(this._result);
    }

    @Override
    public int compareCrafter(ICraftItems crafter) {
        return crafter.compareTo(this._crafter);
    }

    @Override
    public boolean canCraft(IResource type) {
        if (type instanceof ItemResource) {
            return ((ItemResource)type).getItem().equals(this._result.getItem());
        }
        if (type instanceof DictResource) {
            return ((DictResource)type).matches(this._result.getItem(), IResource.MatchSettings.NORMAL);
        }
        return false;
    }

    @Override
    public int getResultStackSize() {
        return this._result.getStackSize();
    }

    @Override
    public IResource getResultItem() {
        return new ItemResource(this._result, null);
    }

    @Override
    public List<IExtraPromise> getByproducts(int workSets) {
        ArrayList<IExtraPromise> list = new ArrayList<IExtraPromise>();
        for (ItemIdentifierStack stack : this._byproduct) {
            list.add(new LogisticsExtraPromise(stack.getItem(), stack.getStackSize() * workSets, (IProvideItems)this.getCrafter(), false));
        }
        return list;
    }

    @Override
    public List<Pair<IResource, IAdditionalTargetInformation>> getComponents(int nCraftingSetsNeeded) {
        ArrayList<Pair<IResource, IAdditionalTargetInformation>> stacks = new ArrayList<Pair<IResource, IAdditionalTargetInformation>>(this._required.size());
        for (Pair<IResource, IAdditionalTargetInformation> stack : this._required) {
            Pair<IResource, IAdditionalTargetInformation> pair = new Pair<IResource, IAdditionalTargetInformation>(stack.getValue1().clone(nCraftingSetsNeeded), stack.getValue2());
            stacks.add(pair);
        }
        return stacks;
    }
}

