/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.IOException;
import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class NEISetCraftingRecipe
extends CoordinatesPacket {
    private ItemStack[] content = new ItemStack[9];

    public NEISetCraftingRecipe(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileEntity tile = this.getTile(player.field_70170_p, TileEntity.class);
        if (tile instanceof LogisticsCraftingTableTileEntity) {
            ((LogisticsCraftingTableTileEntity)tile).handleNEIRecipePacket(this.getContent());
        } else if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            ((PipeBlockRequestTable)((LogisticsTileGenericPipe)tile).pipe).handleNEIRecipePacket(this.getContent());
        }
    }

    @Override
    public ModernPacket template() {
        return new NEISetCraftingRecipe(this.getId());
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.content.length);
        for (int i = 0; i < this.content.length; ++i) {
            ItemStack itemstack = this.content[i];
            if (itemstack == null) continue;
            data.writeByte(i);
            data.writeInt(Item.func_150891_b((Item)itemstack.func_77973_b()));
            data.writeInt(itemstack.field_77994_a);
            data.writeInt(itemstack.func_77960_j());
            data.writeNBTTagCompound(itemstack.func_77978_p());
        }
        data.writeByte(-1);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.content = new ItemStack[data.readInt()];
        byte index = data.readByte();
        while (index != -1) {
            int itemID = data.readInt();
            int stackSize = data.readInt();
            int damage = data.readInt();
            ItemStack stack = new ItemStack(Item.func_150899_d((int)itemID), stackSize, damage);
            stack.func_77982_d(data.readNBTTagCompound());
            this.content[index] = stack;
            index = data.readByte();
        }
    }

    public ItemStack[] getContent() {
        return this.content;
    }

    public NEISetCraftingRecipe setContent(ItemStack[] content) {
        this.content = content;
        return this;
    }
}

