/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class InventoryModuleCoordinatesPacket
extends ModuleCoordinatesPacket {
    private IInventory inventory;
    private List<ItemStack> stackList;
    private List<ItemIdentifierStack> identList;
    private Set<ItemIdentifierStack> identSet;

    public InventoryModuleCoordinatesPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        if (this.inventory != null) {
            data.writeByte(0);
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                data.writeByte(i);
                this.sendItemStack(this.inventory.func_70301_a(i), data);
            }
            data.writeByte(-1);
        } else if (this.stackList != null) {
            data.writeByte(0);
            for (int i = 0; i < this.stackList.size(); ++i) {
                data.writeByte(i);
                this.sendItemStack(this.stackList.get(i), data);
            }
            data.writeByte(-1);
        } else if (this.identList != null) {
            data.writeByte(1);
            for (ItemIdentifierStack stack : this.identList) {
                if (stack == null) {
                    data.writeByte(0);
                    continue;
                }
                data.writeByte(1);
                data.writeItemIdentifierStack(stack);
            }
            data.writeByte(-1);
        } else if (this.identSet != null) {
            data.writeByte(1);
            for (ItemIdentifierStack stack : this.identSet) {
                if (stack == null) {
                    data.writeByte(0);
                    continue;
                }
                data.writeByte(1);
                data.writeItemIdentifierStack(stack);
            }
            data.writeByte(-1);
        } else {
            throw new UnsupportedOperationException("Can't send this Packet without content");
        }
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        byte mode = data.readByte();
        if (mode == 0) {
            this.stackList = new LinkedList<ItemStack>();
            byte index = data.readByte();
            while (index != -1) {
                ((LinkedList)this.stackList).addLast(this.readItemStack(data));
                index = data.readByte();
            }
        } else if (mode == 1) {
            this.identList = new LinkedList<ItemIdentifierStack>();
            byte index = data.readByte();
            while (index != -1) {
                if (index == 0) {
                    ((LinkedList)this.identList).addLast(null);
                } else {
                    ((LinkedList)this.identList).addLast(data.readItemIdentifierStack());
                }
                index = data.readByte();
            }
        } else {
            throw new UnsupportedOperationException("Unknown receive mode: " + mode);
        }
    }

    private void sendItemStack(ItemStack itemstack, LPDataOutputStream data) throws IOException {
        if (itemstack != null) {
            data.writeInt(Item.func_150891_b((Item)itemstack.func_77973_b()));
            data.writeInt(itemstack.field_77994_a);
            data.writeInt(itemstack.func_77960_j());
            data.writeNBTTagCompound(itemstack.func_77978_p());
        } else {
            data.writeInt(0);
        }
    }

    private ItemStack readItemStack(LPDataInputStream data) throws IOException {
        int itemID = data.readInt();
        if (itemID == 0) {
            return null;
        }
        int stackSize = data.readInt();
        int damage = data.readInt();
        ItemStack stack = new ItemStack(Item.func_150899_d((int)itemID), stackSize, damage);
        stack.func_77982_d(data.readNBTTagCompound());
        return stack;
    }

    public InventoryModuleCoordinatesPacket setInventory(IInventory inventory) {
        this.inventory = inventory;
        return this;
    }

    public List<ItemStack> getStackList() {
        return this.stackList;
    }

    public InventoryModuleCoordinatesPacket setStackList(List<ItemStack> stackList) {
        this.stackList = stackList;
        return this;
    }

    public List<ItemIdentifierStack> getIdentList() {
        return this.identList;
    }

    public InventoryModuleCoordinatesPacket setIdentList(List<ItemIdentifierStack> identList) {
        this.identList = identList;
        return this;
    }

    public InventoryModuleCoordinatesPacket setIdentSet(Set<ItemIdentifierStack> identSet) {
        this.identSet = identSet;
        return this;
    }
}

