/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.gui;

import com.nauktis.core.gui.BaseModGui;
import com.nauktis.solarflux.blocks.SolarPanelTileEntity;
import com.nauktis.solarflux.gui.ContainerSolarPanel;
import com.nauktis.solarflux.utility.Lang;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiSolarPanel
extends BaseModGui {
    private static final ResourceLocation ELEMENTS = new ResourceLocation("SolarFlux".toLowerCase(), "textures/gui/elements.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("SolarFlux".toLowerCase(), "textures/gui/solar.png");
    private static final int GAUGE_WIDTH = 18;
    private static final int GAUGE_HEIGHT = 50;
    private static final int GAUGE_INNER_WIDTH = 16;
    private static final int GAUGE_INNER_HEIGHT = 48;
    private static final int GAUGE_INNER_OFFSET_X = 1;
    private static final int GAUGE_INNER_OFFSET_Y = 1;
    private static final int GAUGE_SRC_X = 64;
    private static final int GAUGE_SRC_Y = 62;
    private static final int GAUGE_INNER_SRC_X = 0;
    private static final int GAUGE_INNER_SRC_Y = 64;
    private static final int BORDER_OFFSET = 8;
    private final SolarPanelTileEntity mSolarPanelTileEntity;
    private final InventoryPlayer mInventoryPlayer;

    public GuiSolarPanel(InventoryPlayer pInventoryPlayer, SolarPanelTileEntity pSolarPanelTileEntity) {
        super(new ContainerSolarPanel(pInventoryPlayer, pSolarPanelTileEntity));
        this.mSolarPanelTileEntity = pSolarPanelTileEntity;
        this.mInventoryPlayer = pInventoryPlayer;
        this.field_146999_f = 176;
        this.field_147000_g = 180;
    }

    protected void func_146979_b(int pMouseX, int pMouseY) {
        this.field_146289_q.func_78276_b(this.mInventoryPlayer.func_145818_k_() ? this.mInventoryPlayer.func_145825_b() : I18n.func_135052_a((String)this.mInventoryPlayer.func_145825_b(), (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%s: %,d %s", Lang.localise("energy.stored"), this.mSolarPanelTileEntity.getEnergyStored(), Lang.localise("rf")), 8, 8, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%s: %,d %s", Lang.localise("energy.capacity"), this.mSolarPanelTileEntity.getMaxEnergyStored(), Lang.localise("rf")), 8, 18, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%s: %,d %s", Lang.localise("energy.generation"), this.mSolarPanelTileEntity.getCurrentEnergyGeneration(), Lang.localise("rfPerTick")), 8, 28, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%s: %,d%%", Lang.localise("energy.efficiency"), Math.round(100.0 * (double)this.mSolarPanelTileEntity.getCurrentEnergyGeneration() / (double)this.mSolarPanelTileEntity.getMaximumEnergyGeneration())), 8, 38, 0x404040);
        super.func_146979_b(pMouseX, pMouseY);
    }

    protected void func_146976_a(float pOpacity, int pMouseX, int pMouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(ELEMENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        for (int i = 0; i < 5; ++i) {
            this.func_73729_b(xStart + 17 + i * 18 - 1, yStart + 59 - 1, 0, 0, 18, 18);
        }
        this.drawPower(xStart + this.field_146999_f - 18 - 8, yStart + 8, pMouseX, pMouseY);
        this.drawSun(xStart + this.field_146999_f - 36 - 8 - 4, yStart + 8, pMouseX, pMouseY);
    }

    private void drawPower(int pLeft, int pTop, int pMouseX, int pMouseY) {
        this.func_73729_b(pLeft + 1, pTop + 1, 16, 64, 16, 48);
        int height = this.mSolarPanelTileEntity.getScaledEnergyStoredFraction(48);
        int offset = 48 - height;
        this.func_73729_b(pLeft + 1, pTop + 1 + offset, 0, 64 + offset, 16, height);
        this.func_73729_b(pLeft, pTop + 1 + offset - 1, 64, 61, 18, 1);
        int srcX = 64;
        boolean hover = this.inBounds(pLeft, pTop, 18, 50, pMouseX, pMouseY);
        if (hover) {
            srcX += 18;
        }
        this.func_73729_b(pLeft, pTop, srcX, 62, 18, 50);
        if (hover) {
            String str = String.format("%s: %,d/%,d", Lang.localise("energy.stored"), this.mSolarPanelTileEntity.getEnergyStored(), this.mSolarPanelTileEntity.getMaxEnergyStored());
            this.drawMouseOver(str);
        }
    }

    private void drawSun(int pLeft, int pTop, int pMouseX, int pMouseY) {
        this.func_73729_b(pLeft + 1, pTop + 1, 48, 64, 16, 48);
        int height = (int)(48.0f * this.mSolarPanelTileEntity.getSunIntensity());
        int offset = 48 - height;
        this.func_73729_b(pLeft + 1, pTop + 1 + offset, 32, 64 + offset, 16, height);
        this.func_73729_b(pLeft, pTop + 1 + offset - 1, 82, 61, 18, 1);
        int srcX = 64;
        boolean hover = this.inBounds(pLeft, pTop, 18, 50, pMouseX, pMouseY);
        if (hover) {
            srcX += 18;
        }
        this.func_73729_b(pLeft, pTop, srcX, 62, 18, 50);
        if (hover) {
            String str = String.format("%s: %d%%", Lang.localise("sun.intensity"), (int)(100.0f * this.mSolarPanelTileEntity.getSunIntensity()));
            this.drawMouseOver(str);
        }
    }
}

