/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.blocks.modules;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.nauktis.core.utility.BlockPosition;
import com.nauktis.solarflux.blocks.SolarPanelTileEntity;
import com.nauktis.solarflux.blocks.modules.SimpleEnergyDispenserModule;
import com.nauktis.solarflux.config.ModConfiguration;
import com.nauktis.solarflux.init.ModItems;
import java.util.LinkedList;
import java.util.Set;
import net.minecraftforge.common.util.ForgeDirection;

public class TraversalEnergyDispenserModule
extends SimpleEnergyDispenserModule {
    private final Set<BlockPosition> mVisitedBlocks = Sets.newHashSet();
    private final LinkedList<BlockPosition> mBlocksToVisit = Lists.newLinkedList();
    private int mDirectNeighborDiscovered;

    public TraversalEnergyDispenserModule(SolarPanelTileEntity pTileEntity) {
        super(pTileEntity);
    }

    @Override
    protected void searchTargets() {
        if (this.searchFinished()) {
            this.getTargets().clear();
            this.getTargets().addAll(this.mVisitedBlocks);
            this.mVisitedBlocks.clear();
            this.discoverNeighbors(new BlockPosition(((SolarPanelTileEntity)((Object)this.getTileEntity())).x(), ((SolarPanelTileEntity)((Object)this.getTileEntity())).y(), ((SolarPanelTileEntity)((Object)this.getTileEntity())).z()));
            this.mDirectNeighborDiscovered = this.mBlocksToVisit.size();
        }
        if (this.mVisitedBlocks.size() >= this.mDirectNeighborDiscovered + this.getMaximumExtraTargets()) {
            this.mBlocksToVisit.clear();
        }
        this.progressSearch();
    }

    @Override
    protected int getTargetRefreshRate() {
        return ModConfiguration.getTraversalUpgradeUpdateRate();
    }

    private void progressSearch() {
        if (!this.searchFinished()) {
            BlockPosition position = this.mBlocksToVisit.remove();
            this.mVisitedBlocks.add(position);
            this.discoverNeighbors(position);
        }
    }

    private boolean searchFinished() {
        return this.mBlocksToVisit.isEmpty();
    }

    private void discoverNeighbors(BlockPosition pPosition) {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            BlockPosition neighbor = pPosition.move(direction);
            if (this.mVisitedBlocks.contains(neighbor) || !this.isValidTarget(neighbor)) continue;
            this.mBlocksToVisit.add(neighbor);
        }
    }

    public int getMaximumExtraTargets() {
        return ((SolarPanelTileEntity)((Object)this.getTileEntity())).getUpgradeCount(ModItems.mUpgradeTraversal) * ModConfiguration.getTraversalUpgradeIncrease();
    }
}

