/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Workers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Modules.ModuleBase;

public abstract class ModuleWorker
extends ModuleBase {
    private boolean preWork = true;
    private boolean shouldDie;

    public ModuleWorker(MinecartModular cart) {
        super(cart);
    }

    public abstract byte getWorkPriority();

    public abstract boolean work();

    protected void startWorking(int time) {
        this.getCart().setWorkingTime(time);
        this.preWork = false;
        this.getCart().setWorker(this);
    }

    public void stopWorking() {
        if (this.getCart().getWorker() == this) {
            this.preWork = true;
            this.getCart().setWorker(null);
        }
    }

    public boolean preventAutoShutdown() {
        return false;
    }

    public void kill() {
        this.shouldDie = true;
    }

    public boolean isDead() {
        return this.shouldDie;
    }

    public void revive() {
        this.shouldDie = false;
    }

    protected boolean doPreWork() {
        return this.preWork;
    }

    public Vec3 getLastblock() {
        return this.getNextblock(false);
    }

    public Vec3 getNextblock() {
        return this.getNextblock(true);
    }

    private Vec3 getNextblock(boolean flag) {
        Block b;
        int k;
        int j;
        int i = this.getCart().x();
        if (BlockRailBase.func_150049_b_((World)this.getCart().field_70170_p, (int)i, (int)((j = this.getCart().y()) - 1), (int)(k = this.getCart().z()))) {
            --j;
        }
        if (BlockRailBase.func_150051_a((Block)(b = this.getCart().field_70170_p.func_147439_a(i, j, k)))) {
            int meta = ((BlockRailBase)b).getBasicRailMetadata((IBlockAccess)this.getCart().field_70170_p, (EntityMinecart)this.getCart(), i, j, k);
            if (meta >= 2 && meta <= 5) {
                ++j;
            }
            int[][] logic = MinecartModular.railDirectionCoordinates[meta];
            double pX = this.getCart().pushX;
            double pZ = this.getCart().pushZ;
            boolean xDir = pX > 0.0 && logic[0][0] > 0 || pX == 0.0 || logic[0][0] == 0 || pX < 0.0 && logic[0][0] < 0;
            boolean zDir = pZ > 0.0 && logic[0][2] > 0 || pZ == 0.0 || logic[0][2] == 0 || pZ < 0.0 && logic[0][2] < 0;
            int dir = (xDir && zDir) == flag ? 0 : 1;
            return Vec3.func_72443_a((double)(i + logic[dir][0]), (double)(j + logic[dir][1]), (double)(k + logic[dir][2]));
        }
        return Vec3.func_72443_a((double)i, (double)j, (double)k);
    }

    @Override
    public float getMaxSpeed() {
        if (!this.doPreWork()) {
            return 0.0f;
        }
        return super.getMaxSpeed();
    }

    protected boolean isValidForTrack(int i, int j, int k, boolean flag) {
        boolean result;
        boolean bl = result = this.countsAsAir(i, j, k) && (!flag || World.func_147466_a((IBlockAccess)this.getCart().field_70170_p, (int)i, (int)(j - 1), (int)k));
        if (result) {
            int coordZ;
            int coordY;
            int coordX = i - (this.getCart().x() - i);
            Block block = this.getCart().field_70170_p.func_147439_a(coordX, coordY = j, coordZ = k - (this.getCart().z() - k));
            boolean isWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150432_aD;
            boolean isLava = block == Blocks.field_150353_l || block == Blocks.field_150356_k;
            boolean isOther = block != null && block instanceof IFluidBlock;
            boolean isLiquid = isWater || isLava || isOther;
            result = !isLiquid;
        }
        return result;
    }
}

