/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Addons;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Modules.Addons.ModuleAddon;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.Modules.Workers.ModuleLiquidDrainer;
import vswe.stevescarts.Modules.Workers.Tools.ModuleDrill;

public class ModuleLiquidSensors
extends ModuleAddon {
    private float sensorRotation;
    private int activetime = -1;
    private int mult = 1;

    public ModuleLiquidSensors(MinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.isDrillSpinning()) {
            this.sensorRotation += 0.05f * (float)this.mult;
            if (this.mult == 1 && (double)this.sensorRotation > 0.7853981633974483 || this.mult == -1 && (double)this.sensorRotation < -0.7853981633974483) {
                this.mult *= -1;
            }
        } else {
            if (this.sensorRotation != 0.0f) {
                if (this.sensorRotation > 0.0f) {
                    this.sensorRotation -= 0.05f;
                    if (this.sensorRotation < 0.0f) {
                        this.sensorRotation = 0.0f;
                    }
                } else {
                    this.sensorRotation += 0.05f;
                    if (this.sensorRotation > 0.0f) {
                        this.sensorRotation = 0.0f;
                    }
                }
            }
            if (this.activetime >= 0) {
                ++this.activetime;
                if (this.activetime >= 10) {
                    this.setLight(1);
                    this.activetime = -1;
                }
            }
        }
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.addDw(0, 1);
    }

    private void activateLight(int light) {
        if (this.getLight() == 3 && light == 2) {
            return;
        }
        this.setLight(light);
        this.activetime = 0;
    }

    public void getInfoFromDrill(byte data) {
        byte light = (byte)(data & 3);
        if (light != 1) {
            this.activateLight(light);
        }
        data = (byte)(data & 0xFFFFFFFC);
        data = (byte)(data | this.getLight());
        this.setSensorInfo(data);
    }

    private void setLight(int val) {
        if (this.isPlaceholder()) {
            return;
        }
        byte data = this.getDw(0);
        data = (byte)(data & 0xFFFFFFFC);
        data = (byte)(data | val);
        this.setSensorInfo(data);
    }

    private void setSensorInfo(int val) {
        if (this.isPlaceholder()) {
            return;
        }
        this.updateDw(0, val);
    }

    public int getLight() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getLiquidLight();
        }
        return this.getDw(0) & 3;
    }

    protected boolean isDrillSpinning() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getDrillSpinning();
        }
        return (this.getDw(0) & 4) != 0;
    }

    public float getSensorRotation() {
        return this.sensorRotation;
    }

    public boolean isDangerous(ModuleDrill drill, int x, int y, int z, int p, int q, int r) {
        boolean isFalling;
        boolean isLiquid;
        int x1 = x + p;
        int y1 = y + q;
        int z1 = z + r;
        Block block = this.getCart().field_70170_p.func_147439_a(x1, y1, z1);
        if (block == Blocks.field_150353_l) {
            this.handleLiquid(drill, x1, y1, z1);
            return true;
        }
        if (block == Blocks.field_150355_j) {
            this.handleLiquid(drill, x1, y1, z1);
            return true;
        }
        if (block != null && block instanceof IFluidBlock) {
            this.handleLiquid(drill, x1, y1, z1);
            return true;
        }
        boolean isWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150432_aD;
        boolean isLava = block == Blocks.field_150353_l || block == Blocks.field_150356_k;
        boolean isOther = block != null && block instanceof IFluidBlock;
        boolean bl = isLiquid = isWater || isLava || isOther;
        if (isLiquid) {
            if (q == 1) {
                this.handleLiquid(drill, x1, y1, z1);
                return true;
            }
            int m = this.getCart().field_70170_p.func_72805_g(x1, y1, z1);
            if ((m & 8) == 8) {
                if (block.func_149747_d((IBlockAccess)this.getCart().field_70170_p, x1, y1 - 1, z1, 1)) {
                    this.handleLiquid(drill, x1, y1, z1);
                    return true;
                }
                return false;
            }
            if (isWater && (m & 7) == 7) {
                return false;
            }
            if (isLava && (m & 7) == 7 && this.getCart().field_70170_p.field_73011_w.field_76575_d) {
                return false;
            }
            if (isLava && (m & 7) == 6) {
                return false;
            }
            this.handleLiquid(drill, x1, y1, z1);
            return true;
        }
        if (q == 1 && (isFalling = block instanceof BlockFalling)) {
            return this.isDangerous(drill, x1, y1, z1, 0, 1, 0) || this.isDangerous(drill, x1, y1, z1, 1, 0, 0) || this.isDangerous(drill, x1, y1, z1, -1, 0, 0) || this.isDangerous(drill, x1, y1, z1, 0, 0, 1) || this.isDangerous(drill, x1, y1, z1, 0, 0, -1);
        }
        return false;
    }

    private void handleLiquid(ModuleDrill drill, int x, int y, int z) {
        ModuleLiquidDrainer liquiddrainer = null;
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleLiquidDrainer)) continue;
            liquiddrainer = (ModuleLiquidDrainer)module;
            break;
        }
        if (liquiddrainer != null) {
            liquiddrainer.handleLiquid(drill, x, y, z);
        }
    }
}

