/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Addons;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.HeightControlOre;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.ModuleAddon;

public class ModuleHeightControl
extends ModuleAddon {
    private int levelNumberBoxX = 8;
    private int levelNumberBoxY = 18;
    private int[] arrowUp = new int[]{9, 36, 17, 9};
    private int[] arrowMiddle = new int[]{9, 46, 17, 6};
    private int[] arrowDown = new int[]{9, 53, 17, 9};
    private int oreMapX = 40;
    private int oreMapY = 18;

    public ModuleHeightControl(MinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return Math.max(100, this.oreMapX + 5 + HeightControlOre.ores.size() * 4);
    }

    @Override
    public int guiHeight() {
        return 65;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
        String s = String.valueOf(this.getYTarget());
        int x = this.levelNumberBoxX + 6;
        int color = 0xFFFFFF;
        if (this.getYTarget() >= 100) {
            x -= 4;
        } else if (this.getYTarget() < 10) {
            x += 3;
            if (this.getYTarget() < 5) {
                color = 0xFF0000;
            }
        }
        this.drawString(gui, s, x, this.levelNumberBoxY + 5, color);
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        int pos;
        ResourceHelper.bindResource("/gui/heightcontrol.png");
        this.drawImage(gui, this.levelNumberBoxX, this.levelNumberBoxY, 4, 36, 21, 15);
        this.drawImage(gui, this.arrowUp, 4, 12);
        this.drawImage(gui, this.arrowMiddle, 4, 21);
        this.drawImage(gui, this.arrowDown, 4, 27);
        for (int i = 0; i < HeightControlOre.ores.size(); ++i) {
            HeightControlOre ore = HeightControlOre.ores.get(i);
            for (int j = 0; j < 11; ++j) {
                int srcX;
                int srcY;
                boolean high;
                int altitude = this.getYTarget() - j + 5;
                boolean empty = ore.spanLowest > altitude || altitude > ore.spanHighest;
                boolean bl = high = ore.bestLowest <= altitude && altitude <= ore.bestHighest;
                if (empty) {
                    srcY = 0;
                    srcX = 0;
                } else {
                    srcX = ore.srcX;
                    srcY = ore.srcY;
                    if (high) {
                        srcY += 4;
                    }
                }
                this.drawImage(gui, this.oreMapX + i * 4, this.oreMapY + j * 4, srcX, srcY, 4, 4);
            }
        }
        if (this.getYTarget() != (int)this.getCart().field_70163_u) {
            this.drawMarker(gui, 5, false);
        }
        if ((pos = this.getYTarget() + 5 - (int)this.getCart().field_70163_u) >= 0 && pos < 11) {
            this.drawMarker(gui, pos, true);
        }
    }

    private void drawMarker(GuiMinecart gui, int pos, boolean isTargetLevel) {
        int srcX = 4;
        int srcY = isTargetLevel ? 6 : 0;
        this.drawImage(gui, this.oreMapX - 1, this.oreMapY + pos * 4 - 1, srcX, srcY, 1, 6);
        for (int i = 0; i < HeightControlOre.ores.size(); ++i) {
            this.drawImage(gui, this.oreMapX + i * 4, this.oreMapY + pos * 4 - 1, srcX + 1, srcY, 4, 6);
        }
        this.drawImage(gui, this.oreMapX + HeightControlOre.ores.size() * 4, this.oreMapY + pos * 4 - 1, srcX + 5, srcY, 1, 6);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            byte packetData = 0;
            if (this.inRect(x, y, this.arrowMiddle)) {
                packetData = (byte)(packetData | 1);
            } else {
                if (!this.inRect(x, y, this.arrowUp)) {
                    if (this.inRect(x, y, this.arrowDown)) {
                        packetData = (byte)(packetData | 2);
                    } else {
                        return;
                    }
                }
                if (gui.func_146272_n()) {
                    packetData = (byte)(packetData | 4);
                }
            }
            this.sendPacket(0, packetData);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            byte info = data[0];
            if ((info & 1) != 0) {
                this.setYTarget((int)this.getCart().field_70163_u);
            } else {
                int mult = (info & 2) == 0 ? 1 : -1;
                int dif = (info & 4) == 0 ? 1 : 10;
                int targetY = this.getYTarget();
                if ((targetY += mult * dif) < 0) {
                    targetY = 0;
                } else if (targetY > 255) {
                    targetY = 255;
                }
                this.setYTarget(targetY);
            }
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.addDw(0, (int)this.getCart().field_70163_u);
    }

    public void setYTarget(int val) {
        this.updateDw(0, val);
    }

    @Override
    public int getYTarget() {
        if (this.isPlaceholder()) {
            return 64;
        }
        int data = this.getDw(0);
        if (data < 0) {
            data += 256;
        }
        return data;
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74777_a(this.generateNBTName("Height", id), (short)this.getYTarget());
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.setYTarget(tagCompound.func_74765_d(this.generateNBTName("Height", id)));
    }
}

