/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.data.config.Sync;

public class PacketSyncConfigs
implements IMessage,
IMessageHandler<PacketSyncConfigs, IMessage> {
    private Tuple[] fieldData;

    public void fromBytes(ByteBuf buf) {
        int count = buf.readByte();
        this.fieldData = new Tuple[count];
        for (int i = 0; i < count; ++i) {
            byte[] data = new byte[buf.readShort()];
            buf.readBytes(data);
            ByteArrayInputStream bain = new ByteArrayInputStream(data);
            Tuple tuple = null;
            try {
                tuple = new Tuple();
                tuple.field = new DataInputStream(bain).readUTF();
                tuple.value = new ObjectInputStream(bain).readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tuple == null) {
                this.fieldData = null;
                break;
            }
            this.fieldData[i] = tuple;
        }
    }

    public void toBytes(ByteBuf buf) {
        ArrayList<byte[]> fieldData = new ArrayList<byte[]>();
        for (Field field : ModConfig.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(Sync.class)) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                new DataOutputStream(baos).writeUTF(field.getName());
                new ObjectOutputStream(baos).writeObject(field.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            fieldData.add(baos.toByteArray());
            try {
                baos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        buf.writeByte(fieldData.size());
        for (byte[] data : fieldData) {
            buf.writeShort(data.length);
            buf.writeBytes(data);
        }
    }

    public IMessage onMessage(PacketSyncConfigs message, MessageContext ctx) {
        try {
            for (Tuple tuple : message.fieldData) {
                Field field = ModConfig.class.getField(tuple.field);
                field.set(null, tuple.value);
            }
        }
        catch (Throwable ignored) {
            throw new RuntimeException(ignored);
        }
        return null;
    }

    private static class Tuple {
        private String field;
        private Object value;

        private Tuple() {
        }
    }
}

