/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.items;

import java.util.List;
import makeo.gadomancy.common.registration.RegisteredItems;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.blocks.BlockCustomOreItem;

public class ItemAuraCore
extends Item {
    private IIcon coreBlankIcon;
    private IIcon coreIcon;
    private IIcon borderIcon;

    public ItemAuraCore() {
        this.func_77655_b("ItemAuraCore");
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(RegisteredItems.creativeTab);
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return RegisteredItems.raritySacred;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        AuraCoreType type = this.getCoreType(stack);
        if (type != null) {
            list.add(EnumChatFormatting.GRAY + type.getLocalizedName());
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < AuraCoreType.values().length; ++i) {
            ItemStack stack = new ItemStack(item);
            this.setCoreType(stack, AuraCoreType.values()[i]);
            list.add(stack);
        }
    }

    public void func_94581_a(IIconRegister ir) {
        this.coreBlankIcon = ir.func_94245_a("gadomancy:core_core_blank");
        this.coreIcon = ir.func_94245_a("gadomancy:core_core");
        this.borderIcon = ir.func_94245_a("gadomancy:core_border");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.getCoreType(stack) == AuraCoreType.BLANK && pass == 0) {
            return this.coreBlankIcon;
        }
        return pass == 0 ? this.coreIcon : this.borderIcon;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int func_82790_a(ItemStack stack, int pass) {
        AuraCoreType type;
        if (pass == 0 && (type = this.getCoreType(stack)).isAspect()) {
            if (type.ordinal() < 7) {
                return BlockCustomOreItem.colors[type.ordinal()];
            }
            return type.getAspect().getColor();
        }
        return super.func_82790_a(stack, pass);
    }

    public ItemStack setCoreType(ItemStack itemStack, AuraCoreType type) {
        itemStack.func_77964_b(type.ordinal());
        return itemStack;
    }

    public AuraCoreType getCoreType(ItemStack itemStack) {
        return AuraCoreType.values()[itemStack.func_77960_j()];
    }

    public boolean isBlank(ItemStack itemStack) {
        AuraCoreType type = this.getCoreType(itemStack);
        return type == AuraCoreType.BLANK || type == null;
    }

    public static enum AuraCoreType {
        BLANK("blank"),
        AIR(Aspect.AIR),
        FIRE(Aspect.FIRE),
        WATER(Aspect.WATER),
        EARTH(Aspect.EARTH, true),
        ORDER(Aspect.ORDER),
        ENTROPY(Aspect.ENTROPY, true);

        private final Aspect aspect;
        private final String unlocName;
        private final boolean unused;

        private AuraCoreType(String unlocName) {
            this.unlocName = unlocName;
            this.aspect = null;
            this.unused = false;
        }

        private AuraCoreType(Aspect aspect) {
            this(aspect, false);
        }

        private AuraCoreType(Aspect aspect, boolean unused) {
            this.aspect = aspect;
            this.unlocName = null;
            this.unused = unused;
        }

        public boolean isUnused() {
            return this.unused;
        }

        public boolean isAspect() {
            return this.aspect != null;
        }

        public Aspect getAspect() {
            return this.aspect;
        }

        public String getLocalizedName() {
            String name;
            String string = name = this.isAspect() ? this.aspect.getName() : StatCollector.func_74838_a((String)("gadomancy.auracore." + this.unlocName));
            if (this.unused) {
                name = name + " " + StatCollector.func_74838_a((String)"gadomancy.auracore.unused");
            }
            return name;
        }
    }
}

