/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.familiar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class FamiliarAugment {
    private static final String FORMAT_NAME = "familiar.augment.%s.name";
    public static final FamiliarAugment SHOCK = new FamiliarAugment("shock", new AspectList().add(Aspect.AIR, 3).add(Aspect.ENTROPY, 2));
    public static final FamiliarAugment POISON = new FamiliarAugment("poison", new AspectList().add(Aspect.WATER, 3).add(Aspect.ENTROPY, 4)).addConflict(SHOCK);
    public static final FamiliarAugment FIRE = new FamiliarAugment("fire", new AspectList().add(Aspect.FIRE, 4).add(Aspect.ORDER, 2)).addConflict(SHOCK, POISON);
    public static final FamiliarAugment WEAKNESS = new FamiliarAugment("weakness", new AspectList().add(Aspect.ENTROPY, 3).add(Aspect.EARTH, 3)).addConflict(SHOCK, POISON, FIRE);
    public static final FamiliarAugment DAMAGE_INCREASE = new FamiliarAugment("damage", new AspectList().add(Aspect.FIRE, 3)).addCondition(new PreconditionAny(new FamiliarAugment[]{SHOCK, POISON, FIRE, WEAKNESS}));
    public static final FamiliarAugment RANGE_INCREASE = new FamiliarAugment("range", new AspectList().add(Aspect.AIR, 2).add(Aspect.ORDER, 1)).addConflict(DAMAGE_INCREASE).addCondition(new PreconditionAny(new FamiliarAugment[]{SHOCK, POISON, FIRE, WEAKNESS}));
    public static final FamiliarAugment ATTACK_SPEED = new FamiliarAugment("speed", new AspectList().add(Aspect.ORDER, 2).add(Aspect.FIRE, 1)).addConflict(DAMAGE_INCREASE, RANGE_INCREASE).addCondition(new PreconditionAny(new FamiliarAugment[]{SHOCK, POISON, FIRE, WEAKNESS}));
    private final String unlocalizedName;
    private List<FamiliarAugmentPrecondition> preconditions = new ArrayList<FamiliarAugmentPrecondition>();
    private boolean requiresPrevLevel = true;
    private AspectList costsPerLevel;
    private List<FamiliarAugment> conflicts = new ArrayList<FamiliarAugment>();
    private static Map<String, FamiliarAugment> BY_NAME = new HashMap<String, FamiliarAugment>();

    private FamiliarAugment(String unlocalizedName, AspectList costs) {
        this.unlocalizedName = unlocalizedName;
        this.costsPerLevel = costs;
    }

    private FamiliarAugment setIgnorePreviousLevel() {
        this.requiresPrevLevel = false;
        return this;
    }

    private FamiliarAugment addCondition(FamiliarAugmentPrecondition condition) {
        this.preconditions.add(condition);
        return this;
    }

    private FamiliarAugment addConflict(FamiliarAugment ... others) {
        for (FamiliarAugment augment : others) {
            if (augment == null) continue;
            this.addConflict(augment);
        }
        return this;
    }

    private FamiliarAugment addConflict(FamiliarAugment other) {
        if (!this.conflicts.contains(other)) {
            this.conflicts.add(other);
        }
        if (!other.conflicts.contains(this)) {
            other.conflicts.add(this);
        }
        return this;
    }

    public AspectList getCostsPerLevel() {
        return this.costsPerLevel;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)String.format(FORMAT_NAME, this.unlocalizedName));
    }

    public static FamiliarAugment getByUnlocalizedName(String name) {
        return BY_NAME.get(name.toLowerCase());
    }

    public boolean checkConditions(FamiliarAugmentList currentAugments, int levelToSet) {
        if (levelToSet <= 0) {
            return false;
        }
        for (FamiliarAugmentPair current : currentAugments) {
            if (!this.conflicts.contains(current.augment)) continue;
            return false;
        }
        if (this.requiresPrevLevel) {
            boolean containsAtAll = false;
            int foundLevel = -1;
            for (FamiliarAugmentPair pair : currentAugments) {
                if (!pair.augment.equals(this)) continue;
                containsAtAll = true;
                foundLevel = pair.level;
            }
            if (!containsAtAll ? levelToSet != 1 : foundLevel != levelToSet - 1) {
                return false;
            }
        }
        for (FamiliarAugmentPrecondition precondition : this.preconditions) {
            if (precondition == null || precondition.isFulfilled(currentAugments, levelToSet)) continue;
            return false;
        }
        return true;
    }

    private static void addNameEntry(FamiliarAugment augment, String name) {
        BY_NAME.put(name.toLowerCase(), augment);
    }

    static {
        FamiliarAugment.addNameEntry(SHOCK, FamiliarAugment.SHOCK.unlocalizedName);
        FamiliarAugment.addNameEntry(FIRE, FamiliarAugment.FIRE.unlocalizedName);
        FamiliarAugment.addNameEntry(POISON, FamiliarAugment.POISON.unlocalizedName);
        FamiliarAugment.addNameEntry(WEAKNESS, FamiliarAugment.WEAKNESS.unlocalizedName);
        FamiliarAugment.addNameEntry(DAMAGE_INCREASE, FamiliarAugment.DAMAGE_INCREASE.unlocalizedName);
        FamiliarAugment.addNameEntry(RANGE_INCREASE, FamiliarAugment.RANGE_INCREASE.unlocalizedName);
        FamiliarAugment.addNameEntry(ATTACK_SPEED, FamiliarAugment.ATTACK_SPEED.unlocalizedName);
    }

    public static class FamiliarAugmentPair {
        public final FamiliarAugment augment;
        public final int level;

        public FamiliarAugmentPair(FamiliarAugment augment, int level) {
            this.augment = augment;
            this.level = level;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FamiliarAugmentPair that = (FamiliarAugmentPair)o;
            return this.level == that.level && !(this.augment == null ? that.augment != null : !this.augment.equals(that.augment));
        }

        public int hashCode() {
            int result = this.augment != null ? this.augment.hashCode() : 0;
            result = 31 * result + this.level;
            return result;
        }
    }

    public static class FamiliarAugmentList
    extends ArrayList<FamiliarAugmentPair> {
        public boolean contains(FamiliarAugment augment) {
            return this.getAugmentPair(augment) != null;
        }

        public FamiliarAugmentPair getAugmentPair(FamiliarAugment augment) {
            for (FamiliarAugmentPair pair : this) {
                if (!pair.augment.equals(augment)) continue;
                return pair;
            }
            return null;
        }

        public int getLevel(FamiliarAugment augment) {
            if (!this.contains(augment)) {
                return -1;
            }
            return this.getAugmentPair((FamiliarAugment)augment).level;
        }
    }

    public static class PreconditionAll
    extends FamiliarAugmentPrecondition {
        private FamiliarAugment[] prevAugments;

        private PreconditionAll(FamiliarAugment ... previous) {
            this.prevAugments = previous;
        }

        @Override
        public boolean isFulfilled(FamiliarAugmentList currentAugments, int levelToSet) {
            if (this.prevAugments == null) {
                return true;
            }
            for (FamiliarAugment augment : this.prevAugments) {
                if (augment == null || currentAugments.contains(augment)) continue;
                return false;
            }
            return true;
        }
    }

    public static class PreconditionAny
    extends FamiliarAugmentPrecondition {
        private FamiliarAugment[] anyPrevAugment;

        private PreconditionAny(FamiliarAugment ... any) {
            this.anyPrevAugment = any;
        }

        @Override
        public boolean isFulfilled(FamiliarAugmentList currentAugments, int levelToSet) {
            if (this.anyPrevAugment == null) {
                return true;
            }
            for (FamiliarAugment augment : this.anyPrevAugment) {
                if (augment == null || !currentAugments.contains(augment)) continue;
                return true;
            }
            return false;
        }
    }

    private static abstract class FamiliarAugmentPrecondition {
        private FamiliarAugmentPrecondition() {
        }

        public abstract boolean isFulfilled(FamiliarAugmentList var1, int var2);
    }
}

