/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.events;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import makeo.gadomancy.common.Gadomancy;
import makeo.gadomancy.common.blocks.tiles.TileAIShutdown;
import makeo.gadomancy.common.blocks.tiles.TileBlockProtector;
import makeo.gadomancy.common.blocks.tiles.TileNodeManipulator;
import makeo.gadomancy.common.blocks.tiles.TileStickyJar;
import makeo.gadomancy.common.data.SyncDataHolder;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.entities.EntityItemElement;
import makeo.gadomancy.common.events.EventHandlerEntity;
import makeo.gadomancy.common.items.ItemElement;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.registration.RegisteredItems;
import makeo.gadomancy.common.utils.GolemEnumHelper;
import makeo.gadomancy.common.utils.ItemUtils;
import makeo.gadomancy.common.utils.MiscUtils;
import makeo.gadomancy.common.utils.NBTHelper;
import makeo.gadomancy.common.utils.WandHandler;
import makeo.gadomancy.common.utils.world.TCMazeHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.tiles.TileJarFillable;

public class EventHandlerWorld {
    public Map<EntityItem, Long> trackedItems = new HashMap<EntityItem, Long>();
    private int serverTick = 0;
    private Entity lastUpdated;
    private Map<EntityPlayer, Integer> interacts = null;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void on(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityItem) {
            ItemStack stack = ((EntityItem)event.entity).func_92059_d();
            if (this.isDisguised(stack)) {
                long time = event.world.func_82737_E() + (long)event.world.field_73012_v.nextInt(60) + 40L;
                this.trackedItems.put((EntityItem)event.entity, time);
            }
            if (stack.func_77973_b() instanceof ItemElement && !(event.entity instanceof EntityItemElement)) {
                event.setCanceled(true);
                EntityItemElement newItem = new EntityItemElement(event.world, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, ((EntityItem)event.entity).func_92059_d());
                newItem.field_145804_b = ((EntityItem)event.entity).field_145804_b;
                newItem.field_70159_w = event.entity.field_70159_w;
                newItem.field_70181_x = event.entity.field_70181_x;
                newItem.field_70179_y = event.entity.field_70179_y;
                event.world.func_72838_d((Entity)newItem);
            }
        }
    }

    @SubscribeEvent
    public void on(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.field_72995_K && event.world.func_82737_E() % 10L == 0L) {
            Iterator<Map.Entry<EntityItem, Long>> iterator = this.trackedItems.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<EntityItem, Long> entry = iterator.next();
                EntityItem entity = entry.getKey();
                if (event.world != entity.field_70170_p) continue;
                if (entity.field_70128_L || !this.isDisguised(entity.func_92059_d())) {
                    iterator.remove();
                    continue;
                }
                int x = MathHelper.func_76128_c((double)entity.field_70165_t);
                int y = MathHelper.func_76128_c((double)entity.field_70163_u);
                int z = MathHelper.func_76128_c((double)entity.field_70161_v);
                if (entity.field_145804_b <= 0 && entity.field_70170_p.func_82737_E() - entry.getValue() > 0L) {
                    if (ConfigBlocks.blockFluidPure != event.world.func_147439_a(x, y, z) || event.world.func_72805_g(x, y, z) != 0) continue;
                    NBTTagCompound compound = NBTHelper.getPersistentData(entity.func_92059_d());
                    NBTBase base = compound.func_74781_a("disguise");
                    if (base instanceof NBTTagCompound) {
                        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)base));
                        EntityItem newEntity = new EntityItem(event.world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                        ItemUtils.applyRandomDropOffset(newEntity, event.world.field_73012_v);
                        event.world.func_72838_d((Entity)newEntity);
                    }
                    compound.func_82580_o("disguise");
                    if (compound.func_82582_d()) {
                        NBTHelper.removePersistentData(entity.func_92059_d());
                        if (entity.func_92059_d().func_77978_p().func_82582_d()) {
                            entity.func_92059_d().func_77982_d(null);
                        }
                    }
                    event.world.func_147468_f(x, y, z);
                    continue;
                }
                Gadomancy.proxy.spawnBubbles(event.world, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, 0.2f);
            }
        }
    }

    private boolean isDisguised(ItemStack stack) {
        return NBTHelper.hasPersistentData(stack) && NBTHelper.getPersistentData(stack).func_74764_b("disguise");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void on(LivingEvent.LivingUpdateEvent e) {
        if (!e.entityLiving.field_70170_p.field_72995_K) {
            this.lastUpdated = e.entityLiving;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void on(WorldEvent.Load e) {
        if (!e.world.field_72995_K && e.world.field_73011_w.field_76574_g == 0) {
            Gadomancy.loadModData();
            GolemEnumHelper.validateSavedMapping();
            GolemEnumHelper.reorderEnum();
            TCMazeHandler.init();
        }
        GameRules rules = e.world.func_82736_K();
        rules.field_82771_a.put("mobGriefing", new ValueOverride(this, String.valueOf(rules.func_82766_b("mobGriefing"))));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void on(ExplosionEvent.Start e) {
        Explosion expl = e.explosion;
        if (expl.field_82755_b && (expl.field_77283_e != null ? TileBlockProtector.isSpotProtected(e.world, expl.field_77283_e) : TileBlockProtector.isSpotProtected(e.world, expl.field_77284_b, expl.field_77285_c, expl.field_77282_d))) {
            e.setCanceled(true);
            e.world.func_72885_a(expl.field_77283_e, expl.field_77284_b, expl.field_77285_c, expl.field_77282_d, expl.field_77280_f, expl.field_77286_a, false);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void on(WorldEvent.Unload e) {
        if (!e.world.field_72995_K && e.world.field_73011_w.field_76574_g == 0) {
            Gadomancy.unloadModData();
            TCMazeHandler.closeAllSessionsAndCleanup();
        }
    }

    @SubscribeEvent
    public void on(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        TCMazeHandler.scheduleTick();
        SyncDataHolder.doNecessaryUpdates();
        ++this.serverTick;
        if ((this.serverTick & 0xF) == 0) {
            EventHandlerEntity.registeredLuxPylons.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void on(BlockEvent.PlaceEvent e) {
        TileEntity parent;
        if (e.isCanceled()) {
            if (this.interacts != null) {
                this.interacts.remove(e.player);
            }
        } else if (!e.world.field_72995_K && this.isStickyJar(e.itemInHand) && (parent = e.world.func_147438_o(e.x, e.y, e.z)) instanceof TileJarFillable) {
            int metadata = e.world.func_72805_g(e.x, e.y, e.z);
            e.world.func_147465_d(e.x, e.y, e.z, (Block)RegisteredBlocks.blockStickyJar, metadata, 2);
            TileEntity tile = e.world.func_147438_o(e.x, e.y, e.z);
            if (tile instanceof TileStickyJar) {
                Integer sideHit = this.interacts.get(e.player);
                ((TileStickyJar)tile).init((TileJarFillable)parent, e.placedBlock, metadata, ForgeDirection.getOrientation((int)(sideHit == null ? 1 : sideHit)).getOpposite());
                RegisteredBlocks.blockStickyJar.func_149689_a(e.world, e.x, e.y, e.z, (EntityLivingBase)e.player, e.itemInHand);
            }
        }
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent event) {
        if (!event.world.field_72995_K) {
            TileEntity te;
            if (event.block == RegisteredBlocks.blockNodeManipulator && (te = event.world.func_147438_o(event.x, event.y, event.z)) != null && te instanceof TileNodeManipulator && ((TileNodeManipulator)te).isInMultiblock()) {
                ((TileNodeManipulator)te).breakMultiblock();
            }
            if (event.block == RegisteredBlocks.blockStoneMachine && event.blockMetadata == 5) {
                TileAIShutdown.removeTrackedEntities(event.world, event.x, event.y, event.z);
            }
            if (event.world.field_73011_w.field_76574_g == ModConfig.dimOuterId && event.block == ConfigBlocks.blockEldritchNothing) {
                if (event.getPlayer().field_71075_bZ.field_75098_d && MiscUtils.isANotApprovedOrMisunderstoodPersonFromMoreDoor(event.getPlayer())) {
                    return;
                }
                event.setCanceled(true);
                event.getPlayer().func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"gadomancy.eldritch.nobreakPortalNothing")));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void on(PlayerInteractEvent e) {
        ItemStack i;
        if (!e.world.field_72995_K && e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && this.isStickyJar(e.entityPlayer.func_70694_bm())) {
            if (this.interacts == null) {
                this.interacts = new HashMap<EntityPlayer, Integer>();
            }
            this.interacts.put(e.entityPlayer, e.face);
        }
        if (e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (i = e.entityPlayer.func_70694_bm()) != null && i.func_77973_b() instanceof ItemWandCasting) {
            WandHandler.handleWandInteract(e.world, e.x, e.y, e.z, e.entityPlayer, i);
        }
    }

    private boolean isStickyJar(ItemStack stack) {
        return stack != null && RegisteredItems.isStickyableJar(stack) && stack.func_77942_o() && stack.field_77990_d.func_74767_n("isStickyJar");
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void on(ItemTooltipEvent e) {
        NBTTagCompound compound;
        if (e.toolTip.size() > 0 && e.itemStack.func_77942_o() && e.itemStack.field_77990_d.func_74767_n("isStickyJar")) {
            e.toolTip.add(1, "\u00a7a" + StatCollector.func_74838_a((String)"gadomancy.lore.stickyjar"));
        }
        if (e.toolTip.size() > 0 && NBTHelper.hasPersistentData(e.itemStack) && (compound = NBTHelper.getPersistentData(e.itemStack)).func_74764_b("disguise")) {
            String lore;
            NBTBase base = compound.func_74781_a("disguise");
            if (base instanceof NBTTagCompound) {
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)base));
                lore = String.format(StatCollector.func_74838_a((String)"gadomancy.lore.disguise.item"), EnumChatFormatting.func_110646_a((String)stack.func_82833_r()));
            } else {
                lore = StatCollector.func_74838_a((String)"gadomancy.lore.disguise.none");
            }
            e.toolTip.add("\u00a7a" + lore);
        }
    }

    private static class ValueOverride
    extends GameRules.Value {
        private final EventHandlerWorld handler;

        public ValueOverride(EventHandlerWorld handler, String value) {
            super(value);
            this.handler = handler;
        }

        public boolean func_82758_b() {
            Entity lastUpdated;
            boolean mobGriefing = super.func_82758_b();
            if (mobGriefing && (lastUpdated = this.handler.lastUpdated) != null) {
                StackTraceElement[] elements;
                for (StackTraceElement element : elements = Thread.currentThread().getStackTrace()) {
                    if (!element.getClassName().equals(EntityLivingBase.class.getName()) || !element.getMethodName().equals("func_70071_h") && !element.getMethodName().equals("onUpdate")) continue;
                    return !TileBlockProtector.isSpotProtected(lastUpdated.field_70170_p, lastUpdated);
                }
            }
            return mobGriefing;
        }
    }
}

