/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks;

import java.util.ArrayList;
import java.util.Map;
import makeo.gadomancy.common.blocks.IBlockTransparent;
import makeo.gadomancy.common.blocks.tiles.TileStickyJar;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.registration.RegisteredItems;
import makeo.gadomancy.common.registration.StickyJarInfo;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.blocks.BlockJar;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.ItemEssence;
import thaumcraft.common.tiles.TileJarFillable;

public class BlockStickyJar
extends BlockJar
implements IBlockTransparent {
    private IIcon iconTransparent;

    public BlockStickyJar() {
        this.func_149647_a(null);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileStickyJar stickyJar;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStickyJar && (stickyJar = (TileStickyJar)tile).isValid()) {
            return stickyJar.getParentBlock().func_149673_e(world, x, y, z, side);
        }
        return this.iconTransparent;
    }

    public void func_149651_a(IIconRegister ir) {
        super.func_149651_a(ir);
        this.iconTransparent = ir.func_94245_a("gadomancy:transparent");
    }

    @Override
    public IIcon getTransparentIcon() {
        return this.iconTransparent;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        super.func_149719_a(world, x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStickyJar) {
            this.flipBlockBounds((TileStickyJar)tile);
        }
    }

    private void flipBlockBounds(TileStickyJar stickyJar) {
        ForgeDirection placedOn = stickyJar.placedOn;
        if (placedOn != ForgeDirection.DOWN) {
            float temp;
            float minX = (float)this.func_149704_x();
            float minY = (float)this.func_149665_z();
            float minZ = (float)this.func_149706_B();
            float maxX = (float)this.func_149753_y();
            float maxY = (float)this.func_149669_A();
            float maxZ = (float)this.func_149693_C();
            if (placedOn == ForgeDirection.NORTH || placedOn == ForgeDirection.SOUTH) {
                temp = minZ;
                minZ = minY;
                minY = temp;
                temp = maxZ;
                maxZ = maxY;
                maxY = temp;
            } else if (placedOn == ForgeDirection.WEST || placedOn == ForgeDirection.EAST) {
                temp = minX;
                minX = minY;
                minY = temp;
                temp = maxX;
                maxX = maxY;
                maxY = temp;
            }
            if (placedOn == ForgeDirection.UP || placedOn == ForgeDirection.SOUTH || placedOn == ForgeDirection.EAST) {
                minX = 1.0f - minX;
                minY = 1.0f - minY;
                minZ = 1.0f - minZ;
                maxX = 1.0f - maxX;
                maxY = 1.0f - maxY;
                maxZ = 1.0f - maxZ;
                temp = minX;
                minX = maxX;
                maxX = temp;
                temp = minY;
                minY = maxY;
                maxY = temp;
                temp = minZ;
                minZ = maxZ;
                maxZ = temp;
            }
            this.field_149759_B = minX;
            this.field_149760_C = minY;
            this.field_149754_D = minZ;
            this.field_149755_E = maxX;
            this.field_149756_F = maxY;
            this.field_149757_G = maxZ;
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStickyJar) {
            ItemStack stack = ((TileStickyJar)tile).getParentBlock().getPickBlock(target, world, x, y, z, player);
            NBTHelper.getData(stack).func_74757_a("isStickyJar", true);
            return stack;
        }
        return null;
    }

    public TileStickyJar createTileEntity(World world, int metadata) {
        return new TileStickyJar();
    }

    public int func_149645_b() {
        return RegisteredBlocks.rendererTransparentBlock;
    }

    public void onBlockPlacedOn(TileStickyJar tile, EntityLivingBase player) {
        if (tile.placedOn != ForgeDirection.UP && tile.placedOn != ForgeDirection.DOWN) {
            float pitch = player.field_70125_A;
            float yaw = MathHelper.func_76142_g((float)player.field_70177_z);
            switch (tile.placedOn) {
                case WEST: {
                    yaw -= 90.0f;
                    break;
                }
                case NORTH: {
                    yaw = (180.0f - Math.abs(yaw)) * (float)(yaw < 0.0f ? 1 : -1);
                    break;
                }
                case EAST: {
                    yaw += 90.0f;
                }
            }
            tile.facing = Math.abs(yaw) < Math.abs(pitch) ? (pitch < 0.0f ? ForgeDirection.SOUTH.ordinal() : ForgeDirection.NORTH.ordinal()) : (yaw < 0.0f ? ForgeDirection.EAST.ordinal() : ForgeDirection.WEST.ordinal());
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase ent, ItemStack stack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStickyJar) {
            TileStickyJar stickyJar = (TileStickyJar)tile;
            if (stickyJar.isValid()) {
                stickyJar.getParentBlock().func_149689_a(world, x, y, z, ent, stack);
            }
            this.onBlockPlacedOn(stickyJar, ent);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileStickyJar && ((TileStickyJar)tile).isValid()) {
            ((TileStickyJar)tile).getParent().func_145829_t();
            world.func_147455_a(x, y, z, (TileEntity)((TileStickyJar)tile).getParent());
            ArrayList drops = ((TileStickyJar)tile).getParentBlock().getDrops(world, x, y, z, ((TileStickyJar)tile).getParentMetadata().intValue(), fortune);
            ((TileStickyJar)tile).getParent().func_145843_s();
            world.func_147455_a(x, y, z, tile);
            boolean found = false;
            for (ItemStack drop : drops) {
                if (!RegisteredItems.isStickyableJar(drop)) continue;
                NBTHelper.getData(drop).func_74757_a("isStickyJar", true);
                found = true;
                break;
            }
            if (!found) {
                ItemStack item = new ItemStack(Items.field_151123_aH, 1);
                drops.add(item);
            }
            return drops;
        }
        return new ArrayList<ItemStack>();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float these, float are, float variables) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileStickyJar) {
            TileStickyJar tileStickyJar = (TileStickyJar)tile;
            StickyJarInfo info = RegisteredBlocks.getStickyJarInfo(tileStickyJar.getParentBlock(), world.func_72805_g(x, y, z));
            ItemStack heldItem = player.func_70694_bm();
            if (info.needsPhialHandling() && heldItem != null && heldItem.func_77973_b() == ConfigItems.itemEssence) {
                if (!world.field_72995_K) {
                    BlockStickyJar.handlePhial(world, x, y, z, player, heldItem, tileStickyJar);
                }
                return true;
            }
            boolean handleAspectFilter = info.needsLabelHandling() && heldItem != null && heldItem.func_77973_b() == ConfigItems.itemResource && heldItem.func_77960_j() == 13 && tileStickyJar.aspectFilter == null && (((IEssentiaContainerItem)heldItem.func_77973_b()).getAspects(heldItem) != null || tileStickyJar.amount != 0);
            ForgeDirection newDir = tileStickyJar.changeDirection(ForgeDirection.getOrientation((int)side));
            boolean result = ((TileStickyJar)tile).getParentBlock().func_149727_a(world, x, y, z, player, newDir.ordinal(), these, are, variables);
            if (handleAspectFilter) {
                tileStickyJar.facing = newDir.ordinal();
                tileStickyJar.func_70296_d();
            }
            return result;
        }
        return false;
    }

    public static void handlePhial(World world, int x, int y, int z, EntityPlayer player, ItemStack stack, TileJarFillable tile) {
        ItemEssence itemEssence = (ItemEssence)ConfigItems.itemEssence;
        AspectList aspects = itemEssence.getAspects(stack);
        if (aspects != null) {
            Aspect jarAspect;
            Map.Entry entry = aspects.aspects.entrySet().iterator().next();
            Aspect aspect = jarAspect = tile.aspectFilter == null ? tile.aspect : tile.aspectFilter;
            if ((jarAspect == null || entry.getKey() == jarAspect) && tile.amount + (Integer)entry.getValue() <= tile.maxAmount) {
                tile.addToContainer((Aspect)entry.getKey(), ((Integer)entry.getValue()).intValue());
                --stack.field_77994_a;
                ItemStack essenceStack = new ItemStack((Item)itemEssence, 1, 0);
                if (!player.field_71071_by.func_70441_a(essenceStack)) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), essenceStack));
                }
                player.field_71069_bz.func_75142_b();
            }
        } else {
            Aspect aspect = tile.aspect;
            if (aspect != null && tile.takeFromContainer(aspect, 8)) {
                --stack.field_77994_a;
                ItemStack essenceStack = new ItemStack((Item)itemEssence, 1, 1);
                itemEssence.setAspects(essenceStack, new AspectList().add(aspect, 8));
                if (!player.field_71071_by.func_70441_a(essenceStack)) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), essenceStack));
                }
                player.field_71069_bz.func_75142_b();
            }
        }
    }
}

