/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.ArrayList;
import java.util.List;
import mca.ai.AbstractAI;
import mca.ai.AbstractToggleAI;
import mca.entity.EntityHuman;
import net.minecraft.nbt.NBTTagCompound;

public class AIManager {
    private EntityHuman owner;
    private List<AbstractAI> AIList;

    public AIManager(EntityHuman owner) {
        this.owner = owner;
        this.AIList = new ArrayList<AbstractAI>();
    }

    public void addAI(AbstractAI AI) {
        this.AIList.add(AI);
    }

    public void onUpdate() {
        for (AbstractAI AI : this.AIList) {
            boolean doRun = AI instanceof AbstractToggleAI ? ((AbstractToggleAI)AI).getIsActive() : true;
            if (!doRun) continue;
            AI.onUpdateCommon();
            if (this.owner.field_70170_p.field_72995_K) {
                AI.onUpdateClient();
                continue;
            }
            AI.onUpdateServer();
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        for (AbstractAI AI : this.AIList) {
            AI.writeToNBT(nbt);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        for (AbstractAI AI : this.AIList) {
            AI.readFromNBT(nbt);
        }
    }

    public <T extends AbstractAI> T getAI(Class<T> clazz) {
        for (AbstractAI AI : this.AIList) {
            if (AI.getClass() != clazz) continue;
            return (T)AI;
        }
        return null;
    }

    public boolean isToggleAIActive() {
        for (AbstractAI AI : this.AIList) {
            AbstractToggleAI TAI;
            if (!(AI instanceof AbstractToggleAI) || !(TAI = (AbstractToggleAI)AI).getIsActive()) continue;
            return true;
        }
        return false;
    }

    public String getNameOfActiveAI() {
        for (AbstractAI AI : this.AIList) {
            AbstractToggleAI TAI;
            if (!(AI instanceof AbstractToggleAI) || !(TAI = (AbstractToggleAI)AI).getIsActive()) continue;
            return TAI.getName();
        }
        return "";
    }

    public void disableAllToggleAIs() {
        for (AbstractAI AI : this.AIList) {
            if (!(AI instanceof AbstractToggleAI)) continue;
            AbstractToggleAI TAI = (AbstractToggleAI)AI;
            TAI.setIsActive(false);
        }
    }
}

