/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.plate;

import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermalexpansion.block.plate.BlockPlate;
import cofh.thermalexpansion.block.plate.TilePlateBase;
import cofh.thermalexpansion.gui.client.plate.GuiPlateImpulse;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePlateImpulse
extends TilePlateBase {
    public static final int MIN_INTENSITY = 0;
    public static final int MAX_INTENSITY = 35;
    public static final int MIN_ANGLE = -150;
    public static final int MAX_ANGLE = 600;
    public int intensity = 10;
    public int angle;
    double intensityX;
    double intensityY;

    public static void initialize() {
        GameRegistry.registerTileEntity(TilePlateImpulse.class, (String)"cofh.thermalexpansion.PlateImpulse");
    }

    public TilePlateImpulse() {
        super(BlockPlate.Types.IMPULSE);
        this.updateForce();
    }

    @Override
    public void onEntityCollidedWithBlock(Entity entity) {
        if (this.intensity == 0) {
            return;
        }
        if (this.direction >> 1 == 0 && this.alignment == 0) {
            entity.field_70143_R = 0.0f;
        }
        double[] dArray = this.getVector(this.intensityX, this.intensityY, 0.0);
        this.accelerateEntity(entity, dArray[0], dArray[1], dArray[2]);
    }

    protected void accelerateEntity(Entity entity, double d, double d2, double d3) {
        entity.field_70122_E = false;
        long l = Double.doubleToRawLongBits(entity.field_70159_w);
        long l2 = d == 0.0 ? l ^ 0xFFFFFFFFFFFFFFFFL : Double.doubleToRawLongBits(d);
        l &= (l & Long.MIN_VALUE ^ l2 & Long.MIN_VALUE ^ 0xFFFFFFFFFFFFFFFFL) >> 63;
        entity.field_70159_w = Double.longBitsToDouble(l) + d;
        l = Double.doubleToRawLongBits(entity.field_70181_x);
        l2 = d2 == 0.0 ? l ^ 0xFFFFFFFFFFFFFFFFL : Double.doubleToRawLongBits(d2);
        l &= (l & Long.MIN_VALUE ^ l2 & Long.MIN_VALUE ^ 0xFFFFFFFFFFFFFFFFL) >> 63;
        entity.field_70181_x = Double.longBitsToDouble(l) + d2;
        l = Double.doubleToRawLongBits(entity.field_70179_y);
        l2 = d3 == 0.0 ? l ^ 0xFFFFFFFFFFFFFFFFL : Double.doubleToRawLongBits(d3);
        l &= (l & Long.MIN_VALUE ^ l2 & Long.MIN_VALUE ^ 0xFFFFFFFFFFFFFFFFL) >> 63;
        entity.field_70179_y = Double.longBitsToDouble(l) + d3;
    }

    protected void updateForce() {
        double d = (double)this.angle * Math.PI / 1800.0;
        if (this.direction >> 1 == 0) {
            d = 0.0;
        }
        this.intensityX = Math.cos(d) * (double)this.intensity / 10.0;
        this.intensityY = Math.sin(d) * (double)this.intensity / 10.0;
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.intensity = nBTTagCompound.func_74762_e("Int");
        this.angle = nBTTagCompound.func_74762_e("Angle");
        this.updateForce();
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("Int", this.intensity);
        nBTTagCompound.func_74768_a("Angle", this.angle);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiPlateImpulse(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this, false, false);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.intensity = nBTTagCompound.func_74762_e("Int");
        this.angle = nBTTagCompound.func_74762_e("Angle");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Int", this.intensity);
        nBTTagCompound.func_74768_a("Angle", this.angle);
        this.updateForce();
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addInt(this.intensity);
        packetCoFHBase.addInt(this.angle);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addInt(this.intensity);
        packetCoFHBase.addInt(this.angle);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addInt(MathHelper.clamp((int)this.intensity, (int)0, (int)35));
        packetCoFHBase.addInt(MathHelper.clamp((int)this.angle, (int)-150, (int)600));
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.intensity = packetCoFHBase.getInt();
        this.angle = packetCoFHBase.getInt();
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.intensity = packetCoFHBase.getInt();
        this.angle = packetCoFHBase.getInt();
        this.updateForce();
        this.sendDescPacket();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.intensity = packetCoFHBase.getInt();
            this.angle = packetCoFHBase.getInt();
            this.updateForce();
        } else {
            packetCoFHBase.getInt();
            packetCoFHBase.getInt();
        }
    }

    public ItemStack insertItem(ForgeDirection forgeDirection, ItemStack itemStack) {
        if (forgeDirection.ordinal() >> 1 == this.alignment >> 1) {
            return itemStack;
        }
        double[] dArray = this.fixVector(0.0, -0.25, 0.0);
        EntityItem entityItem = new EntityItem(((TileEntity)this).field_145850_b, (double)((TileEntity)this).field_145851_c + 0.5, (double)((TileEntity)this).field_145848_d + 0.5, (double)((TileEntity)this).field_145849_e + 0.5, itemStack);
        entityItem.field_145804_b = 10;
        entityItem.field_70159_w = dArray[0];
        entityItem.field_70181_x = dArray[1];
        entityItem.field_70179_y = dArray[2];
        ((TileEntity)this).field_145850_b.func_72838_d((Entity)entityItem);
        return null;
    }
}

