/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.registry.GameData;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.World;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.output.NullOutputStream;

public class ItemUtils {
    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            Item item = stack.func_77973_b();
            if (item.hasContainerItem(stack)) {
                return item.getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static NBTTagCompound getItemTag(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        return stack.field_77990_d;
    }

    public static Integer getInt(ItemStack stack, String tagName) {
        NBTTagCompound tag = ItemUtils.getItemTag(stack);
        NBTBase data = tag.func_74781_a(tagName);
        return data != null ? Integer.valueOf(((NBTTagInt)data).func_150287_d()) : null;
    }

    public static EntityItem createDrop(Entity dropper, ItemStack is) {
        return ItemUtils.createEntityItem(dropper.field_70170_p, dropper.field_70165_t, dropper.field_70163_u, dropper.field_70161_v, is);
    }

    public static EntityItem createEntityItem(World world, double x, double y, double z, ItemStack is) {
        return new EntityItem(world, x, y, z, is.func_77946_l());
    }

    public static String getNBTHash(NBTTagCompound tag) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            NullOutputStream dump = new NullOutputStream();
            DigestOutputStream hasher = new DigestOutputStream((OutputStream)dump, digest);
            DataOutputStream output = new DataOutputStream(hasher);
            CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)output);
            byte[] hash = digest.digest();
            return new String(Hex.encodeHex((byte[])hash));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Item getByNameOrId(String id) {
        Item item = (Item)GameData.getItemRegistry().func_82594_a(id);
        if (item != null) {
            return item;
        }
        try {
            int numericId = Integer.parseInt(id);
            return (Item)GameData.getItemRegistry().func_148754_a(numericId);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static ItemStack readStack(NBTTagCompound nbt) {
        Item item = nbt.func_150297_b("id", 8) ? ItemUtils.getByNameOrId(nbt.func_74779_i("id")) : Item.func_150899_d((int)nbt.func_74765_d("id"));
        if (item == null) {
            return null;
        }
        byte stackSize = nbt.func_74771_c("Count");
        short itemDamage = nbt.func_74765_d("Damage");
        ItemStack result = new ItemStack(item, (int)stackSize, (int)itemDamage);
        if (nbt.func_150297_b("tag", 10)) {
            result.field_77990_d = nbt.func_74775_l("tag");
        }
        return result;
    }

    public static NBTTagCompound writeStack(ItemStack stack) {
        String id;
        NBTTagCompound result = new NBTTagCompound();
        stack.func_77955_b(result);
        Item item = stack.func_77973_b();
        if (item != null && (id = GameData.getItemRegistry().func_148750_c((Object)item)) != null) {
            result.func_74778_a("id", id);
        }
        return result;
    }
}

