/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.MethodIdRegistry;
import openmods.network.rpc.RpcCall;
import openmods.network.senders.IPacketSender;
import org.apache.commons.lang3.ArrayUtils;

public class RpcProxyFactory {
    private final MethodIdRegistry registry;

    RpcProxyFactory(MethodIdRegistry registry) {
        this.registry = registry;
    }

    public <T> T createProxy(ClassLoader loader, final IPacketSender sender, final IRpcTarget wrapper, Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        Class[] allInterfaces;
        for (Class intf : allInterfaces = (Class[])ArrayUtils.add((Object[])extraIntf, mainIntf)) {
            Preconditions.checkState((boolean)this.registry.isClassRegistered(intf), (String)"Class %s is not registered as RPC interface", (Object[])new Object[]{intf});
        }
        Object proxy = Proxy.newProxyInstance(loader, allInterfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RpcCall call = new RpcCall(wrapper, method, args);
                sender.sendMessage(call);
                return null;
            }
        });
        return (T)proxy;
    }
}

