/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.game;

import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import java.io.File;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import openmods.config.BlockInstances;
import openmods.config.ConfigStorage;
import openmods.config.InstanceContainer;
import openmods.config.ItemInstances;
import openmods.config.game.ConfigurableFeatureManager;
import openmods.config.game.FactoryRegistry;
import openmods.config.game.FeatureRegistry;
import openmods.config.game.GameConfigProvider;

public class ModStartupHelper {
    private final Set<Class<? extends BlockInstances>> blockHolders = Sets.newHashSet();
    private final Set<Class<? extends ItemInstances>> itemHolders = Sets.newHashSet();
    private final GameConfigProvider gameConfig;

    public ModStartupHelper(String modId) {
        this.gameConfig = new GameConfigProvider(modId);
    }

    public void registerBlocksHolder(Class<? extends BlockInstances> holder) {
        this.blockHolders.add(holder);
    }

    public void registerItemsHolder(Class<? extends ItemInstances> holder) {
        this.itemHolders.add(holder);
    }

    public void preInit(File configFile) {
        this.preInit(new Configuration(configFile));
    }

    public void preInit(Configuration config) {
        ConfigurableFeatureManager features = new ConfigurableFeatureManager();
        for (Class<? extends BlockInstances> clazz : this.blockHolders) {
            features.collectFromBlocks(clazz);
        }
        for (Class<InstanceContainer<Block>> clazz : this.itemHolders) {
            features.collectFromItems(clazz);
        }
        this.registerCustomFeatures(features);
        this.populateConfig(config);
        Table<String, String, Property> properties = features.loadFromConfiguration(config);
        FeatureRegistry.instance.register(features, properties);
        if (config.hasChanged()) {
            config.save();
        }
        ConfigStorage.instance.register(config);
        this.gameConfig.setFeatures(features);
        this.setupIds(this.gameConfig);
        this.setupBlockFactory(this.gameConfig.getBlockFactory());
        this.setupItemFactory(this.gameConfig.getItemFactory());
        for (Class<? extends BlockInstances> clazz : this.blockHolders) {
            this.gameConfig.registerBlocks(clazz);
        }
        for (Class<? extends ItemInstances> clazz : this.itemHolders) {
            this.gameConfig.registerItems(clazz);
        }
        this.setupProvider(this.gameConfig);
    }

    public void handleRenames(FMLMissingMappingsEvent event) {
        this.gameConfig.handleRemaps(event.get());
    }

    protected void setupItemFactory(FactoryRegistry<Item> itemFactory) {
    }

    protected void setupBlockFactory(FactoryRegistry<Block> blockFactory) {
    }

    protected void populateConfig(Configuration config) {
    }

    protected void registerCustomFeatures(ConfigurableFeatureManager features) {
    }

    protected void setupIds(GameConfigProvider gameConfig) {
    }

    protected void setupProvider(GameConfigProvider gameConfig) {
    }
}

