/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import openmods.calc.BinaryOperator;
import openmods.calc.IExecutable;
import openmods.calc.UnaryOperator;

public class OperatorDictionary<E> {
    private final Map<String, BinaryOperator<E>> binaryOperators = Maps.newHashMap();
    private final Map<String, UnaryOperator<E>> unaryOperators = Maps.newHashMap();
    private BinaryOperator<E> defaultOperator;

    public <O extends BinaryOperator<E>> BinaryOperatorRegistration<O> registerBinaryOperator(O operator) {
        IExecutable prev = this.binaryOperators.put(operator.id, operator);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate operator '%s': %s -> %s", (Object[])new Object[]{prev, operator});
        return new BinaryOperatorRegistration(this, operator);
    }

    public <O extends UnaryOperator<E>> O registerUnaryOperator(O operator) {
        IExecutable prev = this.unaryOperators.put(operator.id, operator);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate operator '%s': %s -> %s", (Object[])new Object[]{prev, operator});
        return operator;
    }

    public BinaryOperator<E> registerDefaultOperator(BinaryOperator<E> operator) {
        Preconditions.checkState((this.defaultOperator == null ? 1 : 0) != 0, (String)"Trying to replace default operator: %s -> %s", (Object[])new Object[]{this.defaultOperator, operator});
        this.defaultOperator = operator;
        return operator;
    }

    public Set<String> allOperators() {
        return Sets.union(this.binaryOperators.keySet(), this.unaryOperators.keySet());
    }

    public BinaryOperator<E> getBinaryOperator(String op) {
        return this.binaryOperators.get(op);
    }

    public UnaryOperator<E> getUnaryOperator(String op) {
        return this.unaryOperators.get(op);
    }

    public BinaryOperator<E> getDefaultOperator() {
        return this.defaultOperator;
    }

    public static class BinaryOperatorRegistration<O extends BinaryOperator<E>> {
        private final O op;
        final /* synthetic */ OperatorDictionary this$0;

        private BinaryOperatorRegistration(O op) {
            this.this$0 = this$0;
            this.op = op;
        }

        public BinaryOperatorRegistration<O> setDefault() {
            Preconditions.checkState((this.this$0.defaultOperator == null ? 1 : 0) != 0, (String)"Trying to replace default operator: %s -> %s", (Object[])new Object[]{this.this$0.defaultOperator, this.op});
            this.this$0.defaultOperator = this.op;
            return this;
        }

        public O unwrap() {
            return this.op;
        }
    }
}

