/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import java.math.BigInteger;
import openmods.calc.IValueParser;
import openmods.calc.PositionalNotationParser;
import openmods.calc.Token;
import org.apache.commons.lang3.tuple.Pair;

public class BigIntParser
implements IValueParser<BigInteger> {
    private static final PositionalNotationParser<BigInteger> PARSER = new PositionalNotationParser<BigInteger>(){

        public PositionalNotationParser.Accumulator<BigInteger> createIntegerAccumulator(int radix) {
            final BigInteger bigRadix = BigInteger.valueOf(radix);
            return new PositionalNotationParser.Accumulator<BigInteger>(){
                private BigInteger value = BigInteger.ZERO;

                @Override
                public void add(int digit) {
                    this.value = this.value.multiply(bigRadix).add(BigInteger.valueOf(digit));
                }

                @Override
                public BigInteger get() {
                    return this.value;
                }
            };
        }

        public PositionalNotationParser.Accumulator<BigInteger> createFractionalAccumulator(int radix) {
            throw new IllegalArgumentException("Fractional part not allowed");
        }
    };

    public BigInteger parseToken(Token token) {
        Pair result = PARSER.parseToken(token);
        return (BigInteger)result.getLeft();
    }
}

