/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.storage;

import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class ExtendedBiomeProperties {
    World world;
    HashMap<ChunkCoordIntPair, ChunkProperties> chunkPropertyMap;

    public ExtendedBiomeProperties(World world) {
        this.world = world;
        this.chunkPropertyMap = new HashMap();
    }

    public ChunkProperties getChunkPropertiesFromChunkCoords(int x, int z) {
        ChunkCoordIntPair coordPair = new ChunkCoordIntPair(x, z);
        ChunkProperties properties = this.chunkPropertyMap.get(coordPair);
        if (properties == null) {
            properties = new ChunkProperties(this.world, x, z);
        }
        return properties;
    }

    public ChunkProperties getChunkPropertiesFromBlockCoords(int x, int z) {
        ChunkCoordIntPair coordPair = new ChunkCoordIntPair(x >>= 4, z >>= 4);
        ChunkProperties properties = this.chunkPropertyMap.get(coordPair);
        if (properties == null) {
            properties = new ChunkProperties(this.world, x, z);
        }
        return properties;
    }

    public class ChunkProperties {
        private int[] blockBiomeArray = new int[256];
        private int positionX;
        private int positionZ;

        public ChunkProperties(World world, int x, int z) {
            Arrays.fill(this.blockBiomeArray, -1);
            this.positionX = x;
            this.positionZ = z;
        }

        public int[] getBlockBiomeArray() {
            return this.blockBiomeArray;
        }

        public void setBlockBiomeArray(int[] ints) {
            this.blockBiomeArray = ints;
        }
    }
}

