/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.provider;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;
import org.apache.commons.lang3.ArrayUtils;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.IPlanetaryProvider;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.world.ChunkManagerPlanet;
import zmaster587.advancedRocketry.world.ChunkProviderPlanet;

public class WorldProviderPlanet
extends WorldProvider
implements IPlanetaryProvider {
    private IRenderHandler skyRender;
    public WorldChunkManager chunkMgrTerraformed;

    public IChunkProvider func_76555_c() {
        return new ChunkProviderPlanet(this.field_76579_a, this.field_76579_a.func_72905_C(), false);
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        ChunkCoordinates coords;
        Configuration.canPlayerRespawnInSpace = true;
        if (AtmosphereHandler.hasAtmosphereHandler(this.field_76574_g) && Configuration.canPlayerRespawnInSpace && (coords = player.getBedLocation(this.field_76574_g)) != null && AtmosphereHandler.getOxygenHandler(player.field_70170_p.field_73011_w.field_76574_g).getAtmosphereType(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c).isBreathable()) {
            return this.field_76574_g;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            super.setSkyRenderer((IRenderHandler)new RenderPlanetarySky());
        }
        return super.getSkyRenderer();
    }

    public long getSeed() {
        return super.getSeed() + (long)this.field_76574_g;
    }

    protected void func_76572_b() {
        this.field_76579_a.func_72912_H().func_76085_a(AdvancedRocketry.planetWorldType);
        this.field_76578_c = new ChunkManagerPlanet(this.field_76579_a, DimensionManager.getInstance().getDimensionProperties(this.field_76574_g).getBiomes());
        this.chunkMgrTerraformed = new ChunkManagerPlanet(this.field_76579_a, DimensionManager.getInstance().getDimensionProperties(this.field_76574_g).getTerraformedBiomes());
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.getAtmosphereDensity(0, 0) > 75.0f ? super.canDoRainSnowIce(chunk) : false;
    }

    public void updateWeather() {
        if (this.getAtmosphereDensity(0, 0) > 75.0f) {
            super.updateWeather();
        }
    }

    public boolean func_76567_e() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float p_76560_1_, float p_76560_2_) {
        float f4;
        float[] colors = this.getDimensionProperties((int)((int)Minecraft.func_71410_x().field_71439_g.field_70165_t), (int)((int)Minecraft.func_71410_x().field_71439_g.field_70161_v)).sunriseSunsetColors;
        if (colors == null) {
            return super.func_76560_a(p_76560_1_, p_76560_2_);
        }
        float[] finalColors = new float[4];
        float f2 = 0.4f;
        float f3 = MathHelper.func_76134_b((float)(p_76560_1_ * (float)Math.PI * 2.0f)) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float f5 = (f3 - f4) / f2 * 0.5f + 0.5f;
            float f6 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f5 * (float)Math.PI))) * 0.99f;
            f6 *= f6;
            finalColors[0] = f5 * 0.3f + colors[0];
            finalColors[1] = f5 * f5 * 0.7f + colors[1];
            finalColors[2] = f5 * f5 * 0.1f + colors[2];
            finalColors[3] = f6 * this.getAtmosphereDensityFromHeight(Minecraft.func_71410_x().field_71451_h.field_70163_u, (int)Minecraft.func_71410_x().field_71439_g.field_70165_t, (int)Minecraft.func_71410_x().field_71439_g.field_70161_v);
            return finalColors;
        }
        return null;
    }

    public float getSunBrightness(float partialTicks) {
        float atmosphere = this.getAtmosphereDensity(0, 0);
        Math.abs(1.0f - atmosphere);
        float f1 = this.field_76579_a.func_72826_c(partialTicks);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f) - atmosphere / 4.0f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        if (this.field_76579_a.field_72995_K) {
            DimensionProperties properties = this.getDimensionProperties((int)Minecraft.func_71410_x().field_71439_g.field_70165_t, (int)Minecraft.func_71410_x().field_71439_g.field_70161_v);
            if (properties.isMoon()) {
                f2 = this.eclipseValue(properties, f2, partialTicks);
            } else {
                for (int i : properties.getChildPlanets()) {
                    DimensionProperties childProps = DimensionManager.getInstance().getDimensionProperties(i);
                    f2 = this.eclipseValue(childProps, f2, partialTicks);
                }
            }
        }
        return f2 * super.getSunBrightness(partialTicks);
    }

    private float eclipseValue(DimensionProperties properties, float lightValue, double partialTicks) {
        double currentTheta = (partialTicks * properties.orbitTheta + (1.0 - partialTicks) * properties.prevOrbitalTheta) * 180.0 / Math.PI % 360.0;
        int solarDistance = properties.getSolarOrbitalDistance();
        float planetaryDistance = properties.getParentOrbitalDistance();
        float difference = (float)solarDistance / (200.0f - planetaryDistance + 1.0E-5f);
        float phiMuliplier = Math.max(Math.abs(MathHelper.func_76134_b((float)((float)(properties.orbitalPhi * Math.PI / 180.0)))) - 0.95f, 0.0f) * 20.0f;
        int offset = (int)((200.0f - planetaryDistance) / 2.0f);
        if (phiMuliplier != 0.0f && currentTheta > (double)(180 - offset) && currentTheta < (double)(180 + offset)) {
            lightValue *= phiMuliplier * MathHelper.func_76131_a((float)((float)((double)(difference / 20.0f) + Math.abs(currentTheta - 180.0) * (double)difference / 10.0)), (float)0.0f, (float)1.0f) + (1.0f - phiMuliplier);
        }
        return lightValue;
    }

    public float func_76571_f() {
        return this.getAtmosphereDensity(0, 0) > 0.75f ? 128.0f : -2000.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
        float[] vec = this.getDimensionProperties((int)((int)cameraEntity.field_70165_t), (int)((int)cameraEntity.field_70161_v)).skyColor;
        if (vec == null) {
            return super.getSkyColor(cameraEntity, partialTicks);
        }
        Vec3 skyColorVec = super.getSkyColor(cameraEntity, partialTicks);
        return Vec3.func_72443_a((double)((double)vec[0] * skyColorVec.field_72450_a), (double)((double)vec[1] * skyColorVec.field_72448_b), (double)((double)vec[2] * skyColorVec.field_72449_c));
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float p_76562_1_, float p_76562_2_) {
        Vec3 superVec = super.func_76562_b(p_76562_1_, p_76562_2_);
        float[] vec = this.getDimensionProperties((int)((int)Minecraft.func_71410_x().field_71439_g.field_70165_t), (int)((int)Minecraft.func_71410_x().field_71439_g.field_70161_v)).fogColor;
        return Vec3.func_72443_a((double)((double)vec[0] * superVec.field_72450_a), (double)((double)vec[1] * superVec.field_72448_b), (double)((double)vec[2] * superVec.field_72449_c));
    }

    public boolean func_76568_b(int x, int z) {
        return this.getDimensionProperties(x, z).getAtmosphereDensity() > 100;
    }

    public String func_80007_l() {
        return this.getDimensionProperties(0, 0).getName();
    }

    public int func_76557_i() {
        return 96;
    }

    public double getHorizon() {
        return 63.0;
    }

    public float func_76563_a(long p_76563_1_, float p_76563_3_) {
        int rotationalPeriod = this.getRotationalPeriod(0, 0);
        int j = (int)(p_76563_1_ % (long)rotationalPeriod);
        float f1 = ((float)j + p_76563_3_) / (float)rotationalPeriod - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    @Override
    public double getGravitationalMultiplier(int x, int z) {
        return this.getDimensionProperties((int)x, (int)z).gravitationalMultiplier;
    }

    @Override
    public int getOrbitingDimension(int x, int z) {
        return this.getDimensionProperties(x, z).getParentPlanet();
    }

    @Override
    public int[] getDimensionsInOrbit(int x, int z) {
        Set<Integer> intSet = this.getDimensionProperties(x, z).getChildPlanets();
        Integer[] intArray = new Integer[intSet.size()];
        return ArrayUtils.toPrimitive((Integer[])this.getDimensionProperties(x, z).getChildPlanets().toArray(intArray));
    }

    @Override
    public int getOrbitalDistance(int x, int z) {
        return this.getDimensionProperties((int)x, (int)z).orbitalDist;
    }

    @Override
    public float getAtmosphereDensity(int x, int z) {
        return (float)this.getDimensionProperties(x, z).getAtmosphereDensity() / 100.0f;
    }

    @Override
    public float getAtmosphereDensityFromHeight(double y, int x, int z) {
        return this.getDimensionProperties(x, z).getAtmosphereDensityAtHeight(y);
    }

    @Override
    public int getAverageTemperature(int x, int z) {
        return this.getDimensionProperties((int)x, (int)z).averageTemperature;
    }

    @Override
    public int getRotationalPeriod(int x, int z) {
        return Math.max(this.getDimensionProperties((int)0, (int)0).rotationalPeriod, 1);
    }

    @Override
    public int getWetness() {
        return 0;
    }

    public String getSaveFolder() {
        return "advRocketry/" + super.getSaveFolder();
    }

    @Override
    public boolean isPlanet() {
        return true;
    }

    @Override
    public Vec3 getSunColor(int x, int z) {
        float[] vec = this.getDimensionProperties(x, z).getSunColor();
        return Vec3.func_72443_a((double)vec[0], (double)vec[1], (double)vec[2]);
    }

    public int getSolarOrbitalDistance(int x, int z) {
        return this.getDimensionProperties(x, z).getSolarOrbitalDistance();
    }

    @Override
    public DimensionProperties getDimensionProperties(int x, int z) {
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.field_76574_g);
        return properties == null ? new DimensionProperties(this.field_76574_g) : properties;
    }
}

