/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.ore;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.world.provider.WorldProviderPlanet;
import zmaster587.libVulpes.api.material.AllowedProducts;
import zmaster587.libVulpes.api.material.Material;
import zmaster587.libVulpes.api.material.MaterialRegistry;

public class OreGenerator
extends WorldGenerator
implements IWorldGenerator {
    private void generate(World world, Material material, int numPerChunk, int clumpSize, int chunkX, int chunkZ, Random random) {
        for (int i = 0; i < numPerChunk; ++i) {
            int coordX = 16 * chunkX + random.nextInt(16);
            int coordY = random.nextInt(64);
            int coordZ = 16 * chunkZ + random.nextInt(16);
            new WorldGenMinable(Block.func_149634_a((Item)material.getProduct(AllowedProducts.getProductByName((String)"ORE")).func_77973_b()), material.getMeta(), clumpSize, Blocks.field_150348_b).func_76484_a(world, random, coordX, coordY, coordZ);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        OreGenEvent.GenerateMinable event = new OreGenEvent.GenerateMinable(world, random, (WorldGenerator)this, chunkX, chunkZ, OreGenEvent.GenerateMinable.EventType.CUSTOM);
        MinecraftForge.ORE_GEN_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DENY) {
            if (Configuration.generateCopper) {
                this.generate(world, MaterialRegistry.getMaterialFromName((String)"Copper"), Configuration.copperPerChunk, Configuration.copperClumpSize, chunkX, chunkZ, random);
            }
            if (Configuration.generateTin) {
                this.generate(world, MaterialRegistry.getMaterialFromName((String)"Tin"), Configuration.tinPerChunk, Configuration.tinClumpSize, chunkX, chunkZ, random);
            }
            if (Configuration.generateRutile) {
                this.generate(world, MaterialRegistry.getMaterialFromName((String)"Rutile"), Configuration.rutilePerChunk, Configuration.rutileClumpSize, chunkX, chunkZ, random);
            }
            if (Configuration.generateAluminum) {
                this.generate(world, MaterialRegistry.getMaterialFromName((String)"Aluminum"), Configuration.aluminumPerChunk, Configuration.aluminumClumpSize, chunkX, chunkZ, random);
            }
            if (Configuration.generateDilithium) {
                int dilithiumChance = Configuration.dilithiumPerChunk;
                if (world.field_73011_w instanceof WorldProviderPlanet) {
                    dilithiumChance = DimensionProperties.AtmosphereTypes.getAtmosphereTypeFromValue(DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.field_76574_g).getAtmosphereDensity()) == DimensionProperties.AtmosphereTypes.NONE ? Configuration.dilithiumPerChunkMoon : Configuration.dilithiumPerChunk;
                }
                for (int i = 0; i < dilithiumChance; ++i) {
                    int coordX = 16 * chunkX + random.nextInt(16);
                    int coordY = random.nextInt(64);
                    int coordZ = 16 * chunkZ + random.nextInt(16);
                    new WorldGenMinable(MaterialRegistry.getMaterialFromName((String)"Dilithium").getBlock(), MaterialRegistry.getMaterialFromName((String)"Dilithium").getMeta(), Configuration.dilithiumClumpSize, Blocks.field_150348_b).func_76484_a(world, random, coordX, coordY, coordZ);
                }
            }
        }
    }

    public boolean func_76484_a(World p_76484_1_, Random p_76484_2_, int p_76484_3_, int p_76484_4_, int p_76484_5_) {
        return false;
    }
}

